;Timer0_4.asm, Timer-Interrupt

    .include "tn13def.inc"

    .def   A      = r16
    .def   timer  = r17
    .def   timer2 = r18
    .def   sek    = r19
    .def   min    = r20
    .def   sicher = r21


        rjmp Anfang
        .org 0x0003 
        rjmp TIM0_OVF    ;Timer0 Overflow 
Anfang:
        sbi    ddrb,3     ;Datenrichtung PB3
        ldi    A,3        ;Start mit Vorteiler / 64
        out    TCCR0B,A
        ldi    A,2
        out    TIMSK0,A	   ;Timer Interrupt freigeben
        clr    timer2
        clr    sek
        clr    min
        sei                ;Globaler Interrupt frei   
Schleife:
        cpi    min,3       ;3 Minuten?
        brlo   Schleife
        cli                ;Interrupt sperren 
        sbi    portb,3     ;LED an
        rjmp   Schleife


TIM0_OVF:                  ;Timer Interrupt
        in    sicher, SREG 
        ldi   timer, 6 
        out   TCNT0,timer  ;250 bis Overflow
        inc   timer2
        cpi   timer2,75
        brlo  TIM0_ende
        clr   timer2
        com   A
        out   portb,A
        inc   sek
        cpi   sek,60
        brlo  TIM0_ende
        inc   min
        clr   sek
TIM0_ende:
        out   SREG,sicher
        reti
