unit DRMrx;

interface

uses
  RSLINES, Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    ScrollBar1: TScrollBar;
    F1: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    ScrollBar2: TScrollBar;
    ScrollBar3: TScrollBar;
    Label3: TLabel;
    COMEdit: TEdit;
    SaveSetup: TButton;
    F2: TButton;
    Edit2: TEdit;
    F3: TButton;
    Edit3: TEdit;
    F4: TButton;
    Edit4: TEdit;
    F5: TButton;
    Edit5: TEdit;
    F6: TButton;
    Edit6: TEdit;
    F7: TButton;
    Edit7: TEdit;
    F8: TButton;
    F9: TButton;
    F10: TButton;
    Edit8: TEdit;
    Edit9: TEdit;
    Edit10: TEdit;
    F11: TButton;
    F12: TButton;
    Edit11: TEdit;
    Edit12: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure F1Click(Sender: TObject);
    procedure ScrollBar2Change(Sender: TObject);
    procedure ScrollBar3Change(Sender: TObject);
    procedure SaveSetupClick(Sender: TObject);
    procedure F2Click(Sender: TObject);
    procedure F3Click(Sender: TObject);
    procedure F4Click(Sender: TObject);
    procedure F5Click(Sender: TObject);
    procedure F6Click(Sender: TObject);
    procedure F7Click(Sender: TObject);
    procedure F8Click(Sender: TObject);
    procedure F9Click(Sender: TObject);
    procedure F10Click(Sender: TObject);
    procedure F11Click(Sender: TObject);
    procedure F12Click(Sender: TObject);
    procedure COMEditChange(Sender: TObject);
  private
    { Private-Deklarationen}
  public
    { Public-Deklarationen}
  end;

var
  Form1: TForm1;
  COM: String = 'COM1';
  Osz1: Real = 50000;
  Osz2: Real = 467;
  Freq1 : String = '3995';
  Freq2 : String = '6095';
  Freq3 : String = '6130';
  Freq4 : String = '6140';
  Freq5 : String = '7320';
  Freq6 : String = '9410';
  Freq7 : String = '9655';
  Freq8 : String = '9760';
  Freq9 : String = '9815';
  Freq10 : String = '9850';
  Freq11 : String = '15440';
  Freq12 : String = '15780';
  Frequenz: Integer = 6095;
implementation

{$R *.DFM}

procedure DDSout (data: Integer);
var n, BitValue: Integer;
begin
  TXD (0); // clock
  Delay (0.3);
  DTR (1);
  Delay (0.5);
  BitValue := $8000;
  For n := 0 To 15 do begin
    If (Data And BitValue) > 0 Then RTS (0) Else RTS (1);
    Delay (0.1);
    TXD (1);
    Delay (0.1);
    TXD (0);
    Delay (0.1);
    BitValue := BitValue div 2;
  end;
  Delay (0.3);
  DTR (0);
  Delay (0.5);
end;

procedure LO(freq: Real);
//Label1.Caption = (freq)
var frg : Real;
    Teiler, freqLo, freqHi: Integer;
    freqLoL, freqLoH, freqHiL, freqHiH: Integer;
begin
  freq := freq + Osz2-12;
  frg := freq / Osz1 * $1000000; // 24 Bit
  Teiler := round (frg);
  freqHi := (Teiler div $10000);
  freqLo := Teiler - freqHi * $10000;
//freqLo = frg And &HFFFF

  freqLoL := freqLo And $FF;
  freqLoH := freqLo div $100;
  freqHiL := freqHi And $FF;
  freqHiH := freqHi div $100;
  DDSout($F800);  //Reset
  DDSout($3000 + 0); //4 Bytes to FREQ0
  DDSout($2100 + freqLoL);
  DDSout($3200 + freqLoH);
  DDSout($2300 + freqHiL);
  DDSout($8000);  //Sync
  DDSout($C000);  //Reset end
end;

procedure ReadInit;
VAR  f :TextFile;
     r, n: Integer;
     Zeile: String;
begin
    AssignFile(f,'init.txt');
    {$I-} Reset(f); {$I+}
    r:=IOResult;
    IF r = 0 then begin
      Readln(f,Com);
      Readln (f, Zeile);
      val(Zeile, Osz2, n);
      Osz2 := Osz2/1000;
      Readln (f, Zeile);
      val(Zeile, Osz1, n);
      Osz1 := Osz1/1000;
      Readln (f, Zeile);
      val(Zeile, Frequenz, n);
      Readln (f,Freq1);
      Readln (f,Freq2);
      Readln (f,Freq3);
      Readln (f,Freq4);
      Readln (f,Freq5);
      Readln (f,Freq6);
      Readln (f,Freq7);
      Readln (f,Freq8);
      Readln (f,Freq9);
      Readln (f,Freq10);
      Readln (f,Freq11);
      Readln (f,Freq12);
      CloseFile (f);
    end;
  end;



procedure TForm1.FormCreate(Sender: TObject);
begin
 ReadInit;
 TimeInit;
 ComEdit.Text := COM;
 OPENCOM (Pchar (COM));
 LO (Frequenz);
 Scrollbar1.position := Frequenz;
 Label3.Caption := FloatToStr (Osz1) + ' kHz';
 Label2.Caption := FloatToStr (Osz2) + ' kHz';
 Edit1.text:=Freq1;
 Edit2.text:=Freq2;
 Edit3.text:=Freq3;
 Edit4.text:=Freq4;
 Edit5.text:=Freq5;
 Edit6.text:=Freq6;
 Edit7.text:=Freq7;
 Edit8.text:=Freq8;
 Edit9.text:=Freq9;
 Edit10.text:=Freq10;
 Edit11.text:=Freq11;
 Edit12.text:=Freq12;
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
  Frequenz := ScrollBar1.Position;
  Lo (Frequenz);
  Label1.caption := IntToStr(ScrollBar1.Position)+ ' kHz';
end;


procedure TForm1.ScrollBar2Change(Sender: TObject);
begin
  Osz2 := 467 + (ScrollBar2.Position-100)/50;
  Label2.Caption := FloatToStr (Osz2) + ' kHz';
  LO (Frequenz);
end;

procedure TForm1.ScrollBar3Change(Sender: TObject);
begin
  Osz1 := 50000 + (ScrollBar3.Position-100)/20;
  Label3.Caption := FloatToStr (Osz1) + ' kHz';
  LO (Frequenz);
end;

procedure TForm1.SaveSetupClick(Sender: TObject);
VAR  f :TextFile;
     r: Integer;
begin
    AssignFile(f,'init.txt');
    {$I-} Rewrite(f); {$I+}
    r:=IOResult;
    IF r = 0 then begin
      Writeln(f,ComEdit.text);
      writeln (f, FloatToStr (Osz2*1000));
      writeln (f, FloatToStr (Osz1*1000));
      writeln (f, IntToStr (Frequenz));
      writeln (f,Edit1.text);
      writeln (f,Edit2.text);
      writeln (f,Edit3.text);
      writeln (f,Edit4.text);
      writeln (f,Edit5.text);
      writeln (f,Edit6.text);
      writeln (f,Edit7.text);
      writeln (f,Edit8.text);
      writeln (f,Edit9.text);
      writeln (f,Edit10.text);
      writeln (f,Edit11.text);
      writeln (f,Edit12.text);
      CloseFile (f);
    end;
end;

procedure TForm1.F1Click(Sender: TObject);
var n: Integer;
begin
  val (Edit1.Text,Frequenz,n);
  LO (Frequenz);
  Scrollbar1.position := Frequenz;
end;

procedure TForm1.F2Click(Sender: TObject);
var n: Integer;
begin
  val (Edit2.Text,Frequenz,n);
  LO (Frequenz);
  Scrollbar1.position := Frequenz;
end;

procedure TForm1.F3Click(Sender: TObject);
var n: Integer;
begin
  val (Edit3.Text,Frequenz,n);
  LO (Frequenz);
  Scrollbar1.position := Frequenz;
end;

procedure TForm1.F4Click(Sender: TObject);
var n: Integer;
begin
  val (Edit4.Text,Frequenz,n);
  LO (Frequenz);
  Scrollbar1.position := Frequenz;
end;

procedure TForm1.F5Click(Sender: TObject);
var n: Integer;
begin
  val (Edit5.Text,Frequenz,n);
  LO (Frequenz);
  Scrollbar1.position := Frequenz;
end;

procedure TForm1.F6Click(Sender: TObject);
var n: Integer;
begin
  val (Edit6.Text,Frequenz,n);
  LO (Frequenz);
  Label1.caption := IntToStr(Frequenz);
  Scrollbar1.position := Frequenz;
end;

procedure TForm1.F7Click(Sender: TObject);
var n: Integer;
begin
  val (Edit7.Text,Frequenz,n);
  LO (Frequenz);
  Scrollbar1.position := Frequenz;
end;

procedure TForm1.F8Click(Sender: TObject);
var n: Integer;
begin
  val (Edit8.Text,Frequenz,n);
  LO (Frequenz);
  Scrollbar1.position := Frequenz;
end;

procedure TForm1.F9Click(Sender: TObject);
var n: Integer;
begin
  val (Edit9.Text,Frequenz,n);
  LO (Frequenz);
  Scrollbar1.position := Frequenz;
end;
procedure TForm1.F10Click(Sender: TObject);
var n: Integer;
begin
  val (Edit10.Text,Frequenz,n);
  LO (Frequenz);
  Scrollbar1.position := Frequenz;
end;

procedure TForm1.F11Click(Sender: TObject);
var n: Integer;
begin
  val (Edit11.Text,Frequenz,n);
  LO (Frequenz);
  Scrollbar1.position := Frequenz;
end;

procedure TForm1.F12Click(Sender: TObject);
var n: Integer;
begin
  val (Edit12.Text,Frequenz,n);
  LO (Frequenz);
  Scrollbar1.position := Frequenz;
end;
procedure TForm1.COMEditChange(Sender: TObject);
begin
 if length(ComEdit.Text) > 3 then begin
   CloseCom;
   COM := ComEdit.Text;
   OPENCOM (Pchar (COM));
 end;
end;

end.
