;MAX512.asm  port outputs

#include 8051.H
SPCR .equ 0D5h ; SPI control register
SPDR .equ 86h ; SPI data register
SPSR .equ 0AAh ; SPI status register
SPIF .equ 10000000b ; interrupt flag

CS   .equ P1.4 ; 
MOSI .equ P1.5 ; SPI
MISO .equ P1.6 ; SPI
SCK  .equ P1.7 ; SPI

         .org 0000H

main     mov   a,#00  
         mov   SPCR,#01010000b ; init SPI master  
next     clr   CS       ;chip select 
         mov   r1,a     ;save A
         mov   a,#7
         lcall SPI 
         mov   a,r1     ;restore A
         lcall SPI 
         setb  CS       ;end of chip select
         mov   a,r1     ;restore A
         inc   a        
         sjmp  next     

SPI      mov   SPDR,a   ;output
Busy     mov   a,SPSR   ;status
         anl   a,#SPIF  ;busy?
         jz    Busy     
         mov   a,SPDR   ;read
         ret
         .end
