;I2C-Bus       (I2C_1.ASM)
;11,059MHz, 9600 Baud
;PCF8574
#include 8051.H
         .org 0000H

ANFANG   mov   SP,#60H    ;stack pointer 
INIT     clr   TR1        ;timer 1 stop
         mov   TH1,#0FAH  ;9600 Baud
         mov   TL1,#0FAH
         anl   TMOD,#0FH  ;timer1: 8bit auto reload
         orl   TMOD,#20H
         setb  TR1        ;timer start
         mov   SCON,#50H  ;init RS232
         setb  TI
         orl   PCON,#80H  ;SMOD=1

NEXT     acall RECV       ;I2C adr
         acall I2Start 
         acall I2Out
         acall SEND       ;0 = error        
         acall RECV       ;I2C data
         acall I2Out
         acall SEND       ;0 = error
         acall I2Stop
         acall RECV       ;I2C adr
         inc   a          ;read
         acall I2Start
         acall I2Out      ;Adr
         acall I2In       ;read
         acall I2Nak      ;last byte
         acall I2Stop
         acall SEND 
         sjmp  NEXT

RECV     jnb   RI,RECV
         mov   A,SBUF
         clr   RI
         ret

SEND     jnb   TI,SEND
         clr   TI
         mov   SBUF,A
         ret

SDA      .equ  90h   ;Port 1.1
SCL      .equ  91h   ;Port 1.0

Delay    nop
         nop
         ret

I2Init   setb  SDA
         setb  SCL
         ret

I2Start  clr   SDA
         acall Delay
         clr   SCL
         ret

I2Stop   clr   SCL
         clr   SDA
         acall Delay
         setb  SCL
         acall Delay
         setb  SDA
         ret

I2Ack    clr   SDA
         acall Delay
         setb  SCL
         acall Delay
         clr   SCL
         acall Delay
         ret

I2Nak    setb  SDA
         acall Delay
         setb  SCL
         acall Delay
         clr   SCL
         acall Delay
         ret

I2Out    mov   r3,#8     ;8 bits
S0       jb    ACC.7,S1  ;bit 7 = 1?
         clr   SDA       ;bit = 0
         sjmp  S2        ;bit = 1
S1       setb  SDA       ;bit = 1
S2       acall Delay
         setb  SCL       ;clock
         acall Delay
         clr   SCL
         rl    a         ;next bit in A
         djnz  r3,S0     ;8 bits 
         setb  SDA       ;SDA high Z
         acall Delay
         setb  SCL       ;clock 9
         acall Delay
         jb    SDA,Err   ;Ack?
         clr   SCL
         clr   SDA 
         acall Delay
         ret
Err      mov   A,#0      ;error: return 0 
         clr   SCL
         clr   SDA 
         acall Delay
         ret

I2In     setb  SDA       ;SDA high Z
         mov   A,#0 
         mov   r3,#8     ;8 bits
S4       rl    A         ;next bit
         setb  SCL       ;clock
         acall Delay
         jnb   SDA,S5    ;SDA = 0?
         inc   A         ;Bit 0 = 1
S5       clr   SCL
         acall Delay
         djnz  r3,S4     ;8 bits
         ret
        .end

