unit EZUSB;

interface
uses Windows;

type _ANCHOR_DOWNLOAD_CONTROL = record
   Offset: Word;
end;

type _VENDOR_REQUEST_IN = record
    bRequest : Byte;
    wValue : Word;
    wIndex : Word;
    wLength: Word;
    direction : Byte;
    bData : Byte;
end;

var  InBuffer: Array [0..8191]of Byte;
     OutBuffer: Array [0..8191]of Byte;

procedure WrRAM(Adr: Word; Dat: Byte);
function RdRAM(Adr: Word): Byte;
procedure WriteRAMbytes(StartAdr, NumberOfBytes: Word);
procedure ReadRAMbytes (StartAdr, NumberOfBytes: Word);
procedure ProgStart();
procedure ProgReset();
procedure DownloadBin(FileName:  String);
procedure DownloadIntelHex (FileName: String);


implementation
procedure WrRAM(Adr: Word; Dat: Byte);       //single Byte
var TemplateHandle: THandle;
    DeviceHandle: THandle;
    bresult: Boolean;
    nBytes: DWord;
    MyRequest: _VENDOR_REQUEST_IN;
begin
   myRequest.bRequest := $A0;
   myRequest.wValue := Adr;
   myRequest.wIndex := 0;
   myRequest.wLength := 1;
   myRequest.direction := 0;
   myRequest.bData := Dat;
   DeviceHandle := CreateFile ('\\.\ezusb-0',Generic_write,File_Share_write,nil,open_existing,0,0);
   bResult := DeviceIoControl(DeviceHandle,$00222014,@myRequest,10,nil,0,nBytes,nil);
   CloseHandle (DeviceHandle);
end;

function RdRAM(Adr: Word): Byte;
var DeviceHandle: THandle;    bresult: Boolean;
    nBytes: DWord;
    MyRequest: _VENDOR_REQUEST_IN;
    n: Integer;
    Buffer: Array [1..2] of Byte;
begin
   myRequest.bRequest := $A0;
   myRequest.wValue := Adr;
   myRequest.wIndex := 0;
   myRequest.wLength := 1;
   myRequest.direction := 1;     // Read
   myRequest.bData := $00;

  DeviceHandle := CreateFile ('\\.\ezusb-0', Generic_write,File_Share_write,nil,open_existing,0,0);
  bResult := DeviceIoControl(DeviceHandle,$00222014,@myRequest,10,@Buffer,SizeOf(Buffer),nBytes,nil);
  CloseHandle (DeviceHandle);
  RdRAM := Buffer[1];
end;

procedure WriteRAMbytes(StartAdr, NumberOfBytes: Word);
var DeviceHandle: THandle;
    bresult: Boolean;
    nBytes: DWord;
    downloadControl: _ANCHOR_DOWNLOAD_CONTROL;
begin
  downloadControl.offset:=StartAdr;
  DeviceHandle := CreateFile ('\\.\ezusb-0',Generic_write,File_Share_write,nil,open_existing,0,0);
  bResult := DeviceIoControl(DeviceHandle,$0022206D,@downloadControl,sizeof(downloadControl),@OutBuffer,NumberOfBytes,nBytes,nil);
  CloseHandle (DeviceHandle);
end;

procedure ReadRAMbytes (StartAdr, NumberOfBytes: Word);
var TemplateHandle: THandle;
    DeviceHandle: THandle;    bresult: Boolean;
    nBytes: DWord;
    MyRequest: _VENDOR_REQUEST_IN;
    n: Integer;
begin
   myRequest.bRequest := $A0;
   myRequest.wValue := StartAdr;
   myRequest.wIndex := 0;
   myRequest.wLength := NumberOfBytes; //max. 1024
   myRequest.direction := 1;     // Read
   myRequest.bData := $00;
  DeviceHandle := CreateFile ('\\.\ezusb-0',
  Generic_write,File_Share_write,nil,open_existing,0,TemplateHandle);
  bResult := DeviceIoControl(DeviceHandle,$00222014,@myRequest,10,@InBuffer,SizeOf(InBuffer),nBytes,nil);
  CloseHandle (DeviceHandle);
end;


procedure ProgStart();
begin
   WrRAM($7F92,0);
end;

procedure ProgReset();
begin
   WrRAM($7F92,1);
end;

function HexToInt (Hex: String): Byte;
var h, l: Byte;
begin
  h:= ord (Hex[1])-48;
  if h>9 then h:=h-7;
  l:= ord (Hex[2])-48;
  if l>9 then l:=l-7;
  HexToInt := 16*h+l;
end;

procedure DownloadBin(FileName:  String);
vAR  f :File of Byte;
     r :Byte;
     Adresse, MaxAdresse, n, i : Word;
     Code: Byte;
begin
  AssignFile(f,FileName);
  {$I-} Reset(f); {$I+}
  r:=IOResult;
  if r = 0 then begin
    Adresse := 0;
    for n:=1 to FileSize(f)do begin;
      Read(f,Code);
      OutBuffer [Adresse] := Code;
      Adresse := Adresse + 1;
    end;
    CloseFile(f);
    WriteRAMbytes (0,Adresse)
  end;
end;

procedure DownloadIntelHex (FileName: String);
 VAR  f :TextFile;
      Line: String;
      r,wert :Byte;
      Num: Byte;
      Adr, MaxAdr, n, i, Code : Word;
begin
    AssignFile(f,FileName);
    {$I-} Reset(f); {$I+}
    r:=IOResult;
    IF r = 0 then begin
      MaxAdr :=0;
      repeat
        Readln(f,line);
       Num := HexToInt (copy(line,2,2));
        Adr := 256*HexToInt(copy(line,4,2))+HexToInt(copy(line,6,2));
        if Num>0 then begin
          for i := 1 to Num do begin
             code := HexToInt(copy(line,8+2*i,2));
             OutBuffer[Adr] := code;
             if Adr > MaxAdr then MaxAdr := Adr;
             Adr := Adr + 1;
          end;
        end;
      until Num = 0;
       CloseFile(f);
     end;
     WriteRAMbytes (0,MaxAdr+1);
  end;

end.
