;Serial Interrupt       (COMINT.ASM)
;11,059MHz, 9600 Baud
#include 8051.H
         .org 0000H
         ljmp INIT
         .org 0023H
         ljmp RX

INIT     clr   TR1             ;stop timer 1 
         mov   TH1,#0FAH       ;256-6: 9600 baud
         mov   TL1,#0FAH
         anl   TMOD,#0FH       ;Timer1: 8 bit auto-reload
         orl   TMOD,#20H
         setb  TR1             ;start timer 
         mov   SCON,#50H       ;InitRS232
         setb  TI
         orl   PCON,#80H       ;SMOD=1
         mov   IE,#90H         ;EA +ES

NEXT     mov   A,R7
         mov   R1,A
         mov   A,#255
         mov   P1,A
ON       djnz  R1,ON
         mov   A,R7
         mov   R1,A
         mov   A,#0
         mov   P1,A
OFF      djnz  R1,OFF
         sjmp  NEXT

RX       mov   R7,SBUF
         clr   RI
         reti

        .end
