; Basic52 extension LCD driver  BAS52_LCD.asm
         #include 8051.h

         .org  4030H
         ljmp  LCD        ;UO 1
         .org  403CH
         ljmp  LCD        ;PRINT@
         .org  4100H
         ajmp  LCDInit    ;CALL 0
         ajmp  CURSOR     ;CALL1


         .org  4200H
LCD      push  DPH
         push  DPL
         push  ACC

         acall Busy
         mov   A,28       ;Cusor position
         orl   A,#128
         mov   DPTR,#8000H
         movx  @DPTR,A    ;set Cursor 
         acall Busy
         mov   A,05       ;get char
         cjne  A,#0DH,J1  ;= CR?
         sjmp  CR
J1       cjne  A,#0AH,J2  ;= LF?
         sjmp  End
J2       mov   DPTR,#8002H
         movx  @DPTR,A    ;output char
         mov   A,28       ;Bank3, R4, cursor
         inc   A
         mov   28,A       ;inc cursor 
End      pop   ACC
         pop   DPL
         pop   DPH
         ret

Busy     mov   DPTR,#8001H
         movx  A,@DPTR
         jb    ACC.7,Busy
         ret

CR       acall Busy
         mov   a,#32
         mov   DPTR,#8002h
         movx  @DPTR,a
         mov   A,28
         inc   A
         mov   28,a
         anl   A,#63
         cjne  A,#40,CR
J3       mov   a,28
         anl   a,#192
         mov   28,a
         sjmp  End


LCDInit  push  DPH
         push  DPL
         push  ACC

         acall Busy
         mov   DPTR,#8000H
         mov   A,#38H
         movx  @DPTR,A
         acall Busy
         mov   DPTR,#8000H
         mov   A,#06H
         movx  @DPTR,A
         acall Busy
         mov   DPTR,#8000H
         mov   A,#0CH
         movx  @DPTR,A
         acall Busy
         mov   DPTR,#8000H
         mov   A,#01H
         movx  @DPTR,A
         setb  027H       ;PRINT@ enable

         pop   ACC
         pop   DPL
         pop   DPH
         ret

CURSOR   push  ACC      
         Mov   A,#57
         lcall 030h     
         Mov   A,#1
         lcall 030h     
         mov   A,R1     
         mov   28,A
         pop   ACC      
         ret

        .end
