unit ScopeSios;

interface

uses RSCOMdec,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    Messung: TButton;
    Save: TButton;
    ScrollBar1: TScrollBar;
    Button1: TButton;
    Timer1: TTimer;
    Button2: TButton;
    COM1: TRadioButton;
    COM2: TRadioButton;
    ScrollBar2: TScrollBar;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Timer2: TTimer;
    Timer3: TTimer;
    procedure MessungClick(Sender: TObject);
    procedure Messung2Click(Sender: TObject);
    procedure SaveClick(Sender: TObject);
    procedure ClearClick(Sender: TObject);
    procedure PaintBox1Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure COM1Click(Sender: TObject);
    procedure COM2Click(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure Timer3Timer(Sender: TObject);
    procedure ScrollBar2Change(Sender: TObject);
  end;

var
  Form1: TForm1;
  Buffer : Array [0..1000] of Byte;
  Triggerlevel, TriggerType: Integer;
implementation

{$R *.DFM}



procedure SaveData (Dateiname :String);
var  f : Text;
     n, r : Integer;
begin
  AssignFile(f,dateiname);
  {$I-} ReWrite(f); {$I+}
  r := IOresult;
  if  r = 0 then begin
     for n:=0 to 500 do begin;
        writeln (f,Buffer [n]);
     end;
     CloseFile (f);
  end;
end;

procedure DiagrammInit;
var n: Integer;
begin
  with Form1.Paintbox1.Canvas do begin
  Pen.Color:=ClBlack;
  Brush.Color:=ClWhite;
  Rectangle(30,0,531,257);
  Pen.Color:=ClLtGray;
  for n:= 1 to 10 do begin
      MoveTo(31,256-n*25);
      Lineto (529,256-n*25);
  end;
  Brush.Color:=ClLtGray;
  for n:= 0 to 5 do begin
    TextOut(10,250-n*50,FloatToStr(n)+' V');
  end;
  for n:= 1 to 9 do begin
      MoveTo(30+50*n,254);
      Lineto (30+50*n,0)
  end;
  for n:= 1 to 10 do begin
    TextOut(15+50*n,260,FloatToStr(n*10)+'ms');
  end;
  end;
end;

procedure Plot (Kanal: Integer);
var i: Integer;
begin
  with Form1.Paintbox1.Canvas do begin
    Pen.Color:=ClBlack;
    MoveTo (31,256-Buffer[0]);
    for i := 1 to 499 do
      LineTo (31+i ,256-Buffer[i]);
  end;
end;

procedure SiosStart;

begin;
  Sendbyte (0);
  SendByte (112);
  SendByte (2); SendByte (0);
  SendByte (1); SendByte (0); SendByte (0); SendByte (0);
  SendByte (0); SendByte (0); SendByte (128); SendByte (128);
  SendByte (0); SendByte (0);
  SendByte (1);
  SendByte (5);
  If TriggerType = 0 then SendByte (113);
  If TriggerType > 0 then begin
    SendByte (114+Triggertype);
    if Triggertype < 5 then SendByte (Triggerlevel);
  end;
end;

Procedure SiosRead;
var n, i: Integer;
begin
  SendByte (114);
  for i:= 1 to 14 do begin
    n := ReadByte;
    SendByte (1);
  end;
  for i:= 0 to 500 do begin
    Buffer[i] := ReadByte;
    SendByte (1);
  end;
  n:= ReadByte;
  SendByte (0);
end;

procedure TForm1.MessungClick(Sender: TObject);
begin
  Timer3.enabled := false;
  SiosStart;
  Timer3.Enabled := true;
end;


procedure TForm1.Messung2Click(Sender: TObject);
begin
  DiagrammInit;
end;

procedure TForm1.SaveClick(Sender: TObject);
begin
  SaveData('Output.dat');
end;

procedure TForm1.ClearClick(Sender: TObject);
begin
  DiagrammInit;
end;

procedure TForm1.PaintBox1Click(Sender: TObject);
begin
DiagrammInit;
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
  TriggerLevel := 255-ScrollBar1.Position;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  if (OpenCom('COM2:19200,N,8,2'))=0 then begin
     ShowMessage ('COM2 Error');
     if (OpenCom('COM1:19200,N,8,2'))=0 then
       ShowMessage ('COM1 Error')
     end;
  Triggerlevel := 128;
  Triggertype := 0;
  Sendbyte (65); Sendbyte (128);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Timer1.Enabled := true;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var n,i: Word;
begin
  Timer3.enabled := false;
  SiosStart;
  Timer3.Enabled := true;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Timer1.Enabled := false;
end;

procedure TForm1.COM1Click(Sender: TObject);
begin
  CloseCOM;
  if (OpenCOM ('COM1:19200,N,8,1'))=0 then ShowMessage ('COM1 Error');
end;



procedure TForm1.COM2Click(Sender: TObject);
begin
  TXD (0);
  CloseCOM;
  if (OpenCOM ('COM2:19200,N,8,1'))=0 then ShowMessage ('COM2 Error');
end;

procedure TForm1.Timer2Timer(Sender: TObject);
begin
  DiagrammInit;
  Timer2.Enabled := false;
end;

procedure TForm1.Timer3Timer(Sender: TObject);
begin
  if ReadByte =1 then  begin
    Sendbyte (0);
    SiosRead;
    DiagrammInit;
    Plot (0);
    ClearBuffer;
  end;
end;

procedure TForm1.ScrollBar2Change(Sender: TObject);
begin
  TriggerType := ScrollBar2.Position;
end;

end.

