unit Unit2;

{$mode ObjFPC}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls, ExtCtrls,
  ComCtrls;

type
           //max. array-Größe
Typ_d = array[0..255] of byte;     //Typ_d ist frei wählbar
Typ_e = array[0..255] of byte;     //255 Programmzeilen
Typ_zy = array[0..255] of byte;  //GOSUB Rücksprungadresse
Typ_Bx = array[1..255] of byte;   //B+

  { TForm2 }

  TForm2 = class(TForm)      //Klassen bis end;
    Button10: TButton;
    Button9: TButton;
    CheckBox10: TCheckBox;
    CheckBox11: TCheckBox;
    CheckBox12: TCheckBox;
    CheckBox13: TCheckBox;
    CheckBox14: TCheckBox;
    CheckBox15: TCheckBox;
    CheckBox16: TCheckBox;
    CheckBox17: TCheckBox;
    CheckBox18: TCheckBox;
    CheckBox19: TCheckBox;
    CheckBox20: TCheckBox;
    CheckBox21: TCheckBox;
    CheckBox22: TCheckBox;
    CheckBox23: TCheckBox;
    CheckBox24: TCheckBox;
    CheckBox9: TCheckBox;
    Label1: TLabel;          //Beschriftungen
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label2: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Timer1: TTimer;
    Timer2: TTimer;
    ProgressBar1: TProgressBar;    //Balkenanzeige
    ProgressBar2: TProgressBar;
    Timer3: TTimer;
    TrackBar1: TTrackBar;      //Einstellregler
    TrackBar2: TTrackBar;
    TrackBar3: TTrackBar;

   procedure Button10Click(Sender: TObject);
   procedure Button9Click(Sender: TObject);
   procedure CheckBox9Change(Sender: TObject);
   procedure CheckBox10Change(Sender: TObject);
   procedure CheckBox11Change(Sender: TObject);
   procedure CheckBox12Change(Sender: TObject);
   procedure CheckBox13Change(Sender: TObject);
   procedure CheckBox14Change(Sender: TObject);
   procedure CheckBox15Change(Sender: TObject);
   procedure CheckBox16Change(Sender: TObject);
   procedure CheckBox17Change(Sender: TObject);
   procedure CheckBox18Change(Sender: TObject);
   procedure CheckBox19Change(Sender: TObject);
   procedure CheckBox20Change(Sender: TObject);
   procedure CheckBox21Change(Sender: TObject);
   procedure CheckBox22Change(Sender: TObject);
   procedure CheckBox23Change(Sender: TObject);
   procedure CheckBox24Change(Sender: TObject);
   procedure FormCreate(Sender: TObject);
   procedure PortCheck();
  procedure Timer1Timer(Sender: TObject);
   procedure Timer2Timer(Sender: TObject);
   procedure TrackBar1Change(Sender: TObject);
   procedure TrackBar2Change(Sender: TObject);
   procedure TrackBar3Change(Sender: TObject);

  private

  public

  end;    //Ende von class(TForm)

var                    //das sind Typdefinitionen von Variablen
  Form2: TForm2;
     zmax : byte;      //Variable nur hier definieren, nicht in unit1
                  // Anzahl der Zeilen -1 wg. 0

       z:integer;           //z = Programm-Zeilennummer
     zz,ee : byte;

    L0,L1,L2,L3,L4,L5,L6,L7 : byte;   // checkbox Low
    h0,h1,h2,h3,h4,h5,h6,h7 : byte;   //checkbox High
    High, Low : Byte;

    Pdir : byte;
      Pullup1 : byte;      //Einzelbits
      Pdir1 : byte;        //Einzelbits

    //Arrays:
    D : Typ_d;            //Befehle (Hex-Code)
    E : Typ_e;            //Werte (Hex-Code)
   zy : Typ_zy;           //GOSUB Rücksprungadresse
   Bx : Typ_Bx;           //Speicher B+


    Pout : byte;               //Portausgabe
    Input, Output, Port: byte; //Portzustand
    Step : boolean;
    bit : byte;
  mm, m, n, i : byte;
     AA,BB,CC,DD : byte;   //Speicher von picobasic
    AD0, AD1, AD2, PWM1, PWM2 : byte;
    InputA, Pullup, Pulldown : byte;


implementation        //das eigentliche Program

   uses PicoBasic;
{$R *.lfm}
   const rosa = $008080FF;      //Farbe rosa
{ TForm2 }

 procedure TForm2.PortCheck();      //neue Variante!!!!!!!!!!!!!!!!!!!!
 begin

     High := h0+h1+h2+h3+h4+h5+h6+h7;  //checkbox  Gesamtwert
     Low := L0+L1+L2+L3+L4+L5+L6+L7;

    Port := ((High OR Pullup) AND (NOT Low));

   Input := Port AND (NOT Pdir);   //nur Eingänge

   label4.caption:= ('Input = ' + IntToStr(Input));

      if (Input AND 1 = 1) Then Label11.color := rosa else     //D0
                Label11.color := clwhite;
      if (Input AND 2 = 2) Then Label12.color := rosa else     //D1
                Label12.color := clWhite;
      if (Input AND 4 = 4) Then Label13.color := rosa else     //D2
                Label13.color := clWhite;
      if (Input AND 8 = 8) Then Label14.color := rosa else     //D3
                Label14.color := clWhite;
      if (Input AND 16 =16) Then Label15.color := rosa else    //D4
                Label15.color := clWhite;
      if (Input AND 32 = 32) Then Label16.color := rosa else   //D5
                Label16.color := clWhite;
      if (Input AND 64 = 64) Then Label17.color := rosa else   //D6
                Label17.color := clWhite;
      if (Input AND 128 = 128) Then Label18.color := rosa else //D7
                Label18.color := clWhite;

 Output := Pout AND Pdir; // Ausgänge high

       if (Output AND 1 = 1) Then Label11.color := clred;     //D0
      if (Output AND 2 = 2) Then Label12.color := clred;      //D1
      if (Output AND 4 = 4) Then Label13.color := clred;      //D2
      if (Output AND 8 = 8) Then Label14.color := clred;      //D3
      if (Output AND 16 = 16) Then Label15.color := clred;    //D4
      if (Output AND 32 = 32) Then Label16.color := clred;    //D5
      if (Output AND 64 = 64) Then Label17.color := clred;    //D6
      if (Output AND 128 = 128) Then Label18.color := clred;  //D7

       Label20.caption:= ('Output (X) = ' + IntToStr(Output));

       Port := Input + Output;
        label21.caption:= ('Port = ' + IntToStr(Port));

Output := NOT Pout AND Pdir;   //Ausgänge Low
      if (Output AND 1 = 1) Then Label11.color := clsilver;      //D0
      if (Output AND 2 = 2) Then Label12.color := clsilver;      //D1
      if (Output AND 4 = 4) Then Label13.color := clsilver;      //D2
      if (Output AND 8 = 8) Then Label14.color := clsilver;      //D3
      if (Output AND 16 =16) Then Label15.color := clsilver;     //D4
      if (Output AND 32 = 32) Then Label16.color := clsilver;    //D5
      if (Output AND 64 = 64) Then Label17.color := clsilver;    //D6
      if (Output AND 128 = 128) Then Label18.color := clsilver;  //D7

 end;    //Ende PortCheck


   procedure TForm2.Timer1Timer(Sender: TObject);  //Timer1(Hauptprogramm)...

   var Zeile : String;
       count : byte;

   begin
 count := Form1.ListBox1.Items.Count; //Anzahl der Programmzeilen

       zz := 0; //ausführbare Zeilen (ohne REMs usw.)

      FOR i := 0 to count-2 do
       begin
     Zeile := Form1.ListBox1.Items[i];
     if (copy(Zeile,1,2) = '0x') Then  //wenn Zeile mit 0x beginnt
        begin
           if zz = z Then Form1.ListBox1.ItemIndex := i; //Zeile i highlight
        zz := zz+1;
        end ;
        end;  //end FOR

 Label1.Caption := 'Zeile: ' + IntToStr(z);  //Neu, vor dem Befehl und Z ab 0

       case D[z] of      //Befehle...................

       $1:             // Fall A =
        AA := E[z];

       $2:             //Fall B =
        BB := E[z];

        $3:             //Fall C =
        CC := E[z];

        $4:             //Fall D =
        DD := E[z];

        $8:             //Fall Pout =
        begin
        Pout := E[z];        //neu: Portzustand
        PortCheck;   //neu: Ausgabe über Farben D0...D7
        end;

        $9:          // Fall Pdir
begin
        Pdir := E[z];
        PortCheck;   //neu: Ausgabe über Farben D0...D7

if((Pdir AND 1) = 1)Then CheckBox17.Caption := 'X' else CheckBox17.Caption := '';
if((Pdir AND 2) = 2)Then CheckBox18.Caption := 'X' else CheckBox18.Caption := '';
if((Pdir AND 4) = 4)Then CheckBox19.Caption := 'X' else CheckBox19.Caption := '';
if((Pdir AND 8) = 8)Then CheckBox20.Caption := 'X' else CheckBox20.Caption := '';
if((Pdir AND 16)=16)Then CheckBox21.Caption := 'X' else CheckBox21.Caption := '';
if((Pdir AND 32)=32)Then CheckBox22.Caption := 'X' else CheckBox22.Caption := '';
if((Pdir AND 64)=64)Then CheckBox23.Caption := 'X' else CheckBox23.Caption := '';
if((Pdir AND 128) = 128)Then CheckBox24.Caption:='X'else CheckBox24.Caption := '';

if((Pdir AND 1) = 1)Then CheckBox9.Caption := 'X' else CheckBox9.Caption := '';
if((Pdir AND 2) = 2)Then CheckBox10.Caption := 'X' else CheckBox10.Caption := '';
if((Pdir AND 4) = 4)Then CheckBox11.Caption := 'X' else CheckBox11.Caption := '';
if((Pdir AND 8) = 8)Then CheckBox12.Caption := 'X' else CheckBox12.Caption := '';
if((Pdir AND 16)=16)Then CheckBox13.Caption := 'X' else CheckBox13.Caption := '';
if((Pdir AND 32)=32)Then CheckBox14.Caption := 'X' else CheckBox14.Caption := '';
if((Pdir AND 64)=64)Then CheckBox15.Caption := 'X' else CheckBox15.Caption := '';
if((Pdir AND 128) = 128)Then CheckBox16.Caption:='X'else CheckBox16.Caption := '';

end;       //Ende Fall Pdir ..............................

          $A:     //Fall Pullup .................................
          begin
          Pullup := E[z];
             PortCheck;   //neu: Ausgabe über Farben D0...D7
          end;     //Ende Pullup.................................

          $B:     //Fall Pulldown
              begin
          Pulldown := E[z];         //Pulldown ist default
          Pullup := Pullup and (not(Pulldown));  //Pullups werden gelöscht
          PortCheck;   //neu: Ausgabe über Farben D0...D7
          end;

           $10:      //Fall PWM1 =
ProgressBar1.Position := E[z];

           $11:      //Fall PWM1 =
ProgressBar2.Position := E[z];

           $12:       //Fall A = A AND
           AA := AA AND E[z];

           $13:       //Fall A = A OR
           AA := AA OR E[z];

           $18:        //Fall Delay us
           begin
               //keine Umsetzung
           end;

           $19:       //Fall Delay ms
        begin
          if step = false Then
           begin
        timer1.Enabled := false;
         timer2.interval := E[z];    //timer2 = Verzögerungszeit
         timer2.Enabled := true;
           end;
        end ;

          $1A:       //Fall Delay s
        begin
          if step = false Then
           begin
        timer1.Enabled := false;
         timer2.interval := E[z]*1000;    //timer2 = Verzögerungszeit
         timer2.Enabled := true;
           end;
        end ;

          $1B:       //Fall Delay min
        begin
          if step = false Then
           begin
        timer1.Enabled := false;
         timer2.interval := E[z]*60000;    //timer2 = Verzögerungszeit
         timer2.Enabled := true;
           end;
        end ;

       $20:             //Fall goto E(z)
       begin
       z:= E[z]-1;       //nach E(z) springen, -1 wg. z=z+1
       end;

       $21:               //Fall GOSUB
        begin
          zy[n] := z;      //Rücksprungadresse merken
           n := n+1;        //nächstes GOSUB (Schachtelung)
           Form1.Edit8.text := IntToStr(E[z]);
           if E[z] < zmax then z:= E[z]-1;      //nach E(z) springen
        end;

       $22:              //Fall IF A = B GOTO E(z)
        begin
            if AA=BB then  z := E[z]-1;
        end;

        $23:              //Fall IF A > B GOTO E(z)
        begin
            if AA>BB then   z := E[z]-1;
         end;

       $24:              //Fall  IF A < B GOTO E(z)
       begin
           if AA<BB then   z := E[z]-1;
        end;

       $25:             //Fall C*GOTO E(z)
begin
         IF CC>0 Then
          begin
           CC := CC - 1;
           z:= E[z]-1;    //GOTO E(z)
         end;
end;

       $26:             //Fall D*GOTO E)z)
 begin
         IF DD>0 Then
          begin
           DD := DD - 1;
           z:= E[z]-1;    //GOTO E(z)
         end;
end;

        $28:           //Fall A = A + 1
        AA := AA + 1;

        $29:           //Fall A = A - 1
        AA := AA - 1;

        $2A:           //Fall A = A + B
        AA := AA + BB;

        $2B:           //Fall A = A - B
        AA := AA - BB;

        $2C:           //Fall A = A * B
        AA := AA * BB;

        $2D:           //Fall A = A / B
        AA := AA div BB;

        $2E:            //Fall A AND B
        AA := AA AND BB;

        $2F:            //Fall A OR B
        AA := AA OR BB;

         $30:            //Fall A XOR B
        AA := AA XOR BB;

         $31:            //Fall A shift left 1
        AA := AA*2;

         $32:            //Fall A shift right 1
        AA := AA div 2;

          $33:           //Fall A NOT A
         AA := NOT AA;

        $34:           //Fall B = A
          BB := AA;

        $35:
         AA := BB;      //Fall A = B

        $36:
        CC := AA;       //Fall C = A

        $37:            //Fall A = C
        AA := CC;

        $38:            //Fall D = A
        DD := AA;

        $39:            //Fall A = D
        AA := DD;

         $3A:           //Fall A = B+
           begin
           mm := BB;      //für Label
            AA := Bx[BB];
            BB := BB+1;

           end;

          $3B:           //Fall B+ = A
           begin
             mm := BB;      //für Label
             Bx[BB] := AA;
             BB := BB+1;
           end;

           $3C:          //Fall A = AD0
        AA := AD0;

        $3D:           //Fall A = AD1
        AA := AD1;

        $3E:           //Fall A = AD2
        AA := AD2;

        $3F:            //Fall A = Pin
        AA := Port;     // neu

        $40:          //Fall A = Pin 0
        AA := Port and 1;

         $41:          //Fall Input A
         begin
          AA := InputA;
         end;

         $42:          //Fall Print A
         begin
          Form1.Edit8.text := IntToStr(AA);
         end;

         $43:          //Fall PWM1 = A
ProgressBar1.Position := AA;

         $44:          //Fall PWM2 = A
ProgressBar2.Position := AA;

       $45:          //Fall Pout = A
       begin
        Pout := AA;        //neu: Portzustand
        PortCheck;   //neu: Ausgabe über Farben
       end;

        $48:          //Fall RETURN
        begin
        n := n-1;      //aktuelles GOSUB
        z := zy[n] //+ 1; //Rücksprung auf nächste Zeile z = z+1
         end;

        $49:            //Fall End
           begin
timer1.Enabled := false; //stop der Simulation
            z := -1;

            if Button9.Tag = 0 then   //Button auf START stellen
   begin
      timer1.Enabled := false;
      timer2.Enabled := false;
button9.caption :=  'Start' ;
  Button9.tag := 1 ;
Button9.Height := 30;
   end
           end;

        $4A:            //Fall Nop
           begin
              //nichts
           end;


 end;      //case end ........................................


 Label8.Caption := 'A = ' + IntToStr(AA) + '   B = ' + IntToStr(BB) +
 '  C = ' + IntToStr(CC) + '  D = ' + IntToStr(DD) +
 '  [B+(' + IntToStr(mm) +')] = ' + IntToStr(Bx[mm]);

  if (step = false) then
begin
     //bei Run nächste Zeile
         z := z+1;
end
  else
  begin
  timer1.Enabled := false;   //bei step
  z := z + 1;               //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  end;

  if z > zmax Then    //::::::MessageBox:::::::::::::::
   begin
       timer1.Enabled := false;
      showMessage('Programmfehler: Es wurde eine Zeile außerhalb des aktuellen Programms aufgerufen');
      z := 0;
   end;

end;     // Ende Timer1    .....................................

procedure TForm2.Timer2Timer(Sender: TObject);  //Delay
begin
      Begin
      timer2.Enabled := false;
      timer1.Enabled := true;
      end;
end;

procedure TForm2.TrackBar1Change(Sender: TObject); //Einstellregler AD0
begin
    AD0 := TrackBar1.Position;
end;

procedure TForm2.TrackBar2Change(Sender: TObject); //Einstellregler AD1....
begin

  AD1 := TrackBar2.Position;
end;

procedure TForm2.TrackBar3Change(Sender: TObject); //Einstellregler AD2....
begin
     AD2 :=  TrackBar3.Position;

end;

procedure TForm2.FormCreate(Sender: TObject);     //Starteinstellungen
begin
  timer2.Enabled := false;
  Timer1.Interval := 100;
  Timer1.Enabled := false;
  Label1.caption := '';
  Label8.caption := '';

  z := 0;
  zz := 0;
  n := 0;
  m := 0;
  step := false;
  Pdir := 0;         //neu
  Pout := 0;         //neu
  Pullup := 0;       //neu
  Pulldown := 0;     //neu

   AA := 0;          //Speicher
    BB := 0;
     CC := 0;
      DD := 0;

  Canvas.Pen.Width := 10;
  button10. Enabled := false;  //Step

  // TrackBar konfigurieren
  TrackBar1.Min := 0;           //AD0
  TrackBar1.Max := 255;
  TrackBar1.Position := 50;

  TrackBar2.Min := 0;        //AD1
  TrackBar2.Max := 255;
  TrackBar2.Position := 50;

  TrackBar3.Min := 0;           //AD2
  TrackBar3.Max := 255;
  TrackBar3.Position := 50;

  // ProgressBar konfigurieren
  ProgressBar1.Min := 0;                //PWM1
  ProgressBar1.Max := 255;
  ProgressBar1.Position := 5;

  ProgressBar2.Min := 0;                 //PWM2
  ProgressBar2.Max := 255;
  ProgressBar2.Position := 5;

end;


procedure TForm2.Button10Click(Sender: TObject);   //Step
begin

 if Button10.Tag = 0 then
   begin
  Button10.tag := 1 ;
  Button10.Height := 30;
  step := true;
  timer3.Enabled := true; //timer.tick "betätigt" button und stellt ihn zurück
  end
else
  begin
   Button10.tag := 0 ;
   Button10.Height := 25;
timer3.Enabled := false;
timer1.Enabled := true;
   end;
end;

procedure TForm2.Button9Click(Sender: TObject);    //Start / Stop
begin
 FormCreate(Self);         //FormCreate aufrufen. Alles auf Null stellen
 Pdir := 0;         //neu
 Pout := 0;        //neu
 Pullup := 0;       //neu
 Pulldown := 0;     //neu
 PortCheck;         //neu: Port aktualisieren
step := false;
 button10.Enabled := true;  //Button "Step"

           if Button9.Tag = 0 then
   begin
      timer1.Enabled := false;
      timer2.Enabled := false;
button9.caption :=  'Start' ;
  Button9.tag := 1 ;
Button9.Height := 30;

  end
else
  begin
   Button9.caption :=  'Stop' ;
   Button9.tag := 0 ;
   Button9.Height := 25;
   timer1.Enabled := true;
   timer2.Enabled := false;
   end;
end;

procedure TForm2.CheckBox17Change(Sender: TObject);    //D0 oben
begin
      if CheckBox17.Checked = True then
        begin
           h0 := 1; CheckBox9.checked := false;
           end
        else h0 := 0;
PortCheck;    //Unterprogramm
end;


procedure TForm2.CheckBox18Change(Sender: TObject);   //D1 oben
begin
        if CheckBox18.Checked = True then
        begin
           h1 := 2; CheckBox10.checked := false;
           end
        else h1 := 0;

   PortCheck;
end;


procedure TForm2.CheckBox19Change(Sender: TObject);  //D2 oben
begin
   if CheckBox19.Checked = True then
     begin
     h2 := 4; CheckBox11.checked := false;
     end
   else
     h2 := 0;

   PortCheck;
end;


procedure TForm2.CheckBox20Change(Sender: TObject);  //D3 oben
begin
   if CheckBox20.Checked = True then
     begin
     h3 := 8; CheckBox12.checked := false;
     end
   else
     h3 := 0;

   PortCheck;
end;

procedure TForm2.CheckBox21Change(Sender: TObject);  //D4 oben
begin
   if CheckBox21.Checked = True then
     begin
     h4 := 16;  CheckBox13.checked := false;
      end
   else
     h4 := 0;

   PortCheck;
end;


procedure TForm2.CheckBox22Change(Sender: TObject); //D5 oben
begin
   if CheckBox22.Checked = True then
     begin
     h5 := 32; CheckBox14.checked := false;
     end
   else
     h5 := 0;

   PortCheck;
end;


procedure TForm2.CheckBox23Change(Sender: TObject);   //D6 oben
begin
   if CheckBox23.Checked = True then
     begin
     h6 := 64;  CheckBox15.checked := false;
     end
   else
     h6 := 0;

   PortCheck;
end;


procedure TForm2.CheckBox24Change(Sender: TObject);   //D7 oben
begin
   if CheckBox24.Checked = True then
     begin
        h7 := 128;  CheckBox16.checked := false;
     end
     else
     h7 := 0;
   PortCheck;
end;



procedure TForm2.CheckBox9Change(Sender: TObject);   //D0 unten
begin
   if CheckBox9.Checked = True then
     begin
     L0 := 1;  CheckBox17.checked := false;
     end
   else
     L0 := 0;

   PortCheck;
end;


procedure TForm2.CheckBox10Change(Sender: TObject);  //D1 unten
begin
   if CheckBox10.Checked = True then
     begin
   L1 := 2; CheckBox18.checked := false;
      end
   else L1 := 0;

   PortCheck;
end;


procedure TForm2.CheckBox11Change(Sender: TObject);  //D2 unten
begin
   if CheckBox11.Checked = True then
     begin
   L2 := 4; CheckBox19.checked := false;
   end
   else L2 := 0;

   PortCheck;
end;


procedure TForm2.CheckBox12Change(Sender: TObject);   //D3 unten
begin
   if CheckBox12.Checked = True then
     begin
   L3:= 8;  CheckBox20.checked := false;
   end
   else L3 := 0;

   PortCheck;
end;


procedure TForm2.CheckBox13Change(Sender: TObject);  //D4 unten
begin
   if CheckBox13.Checked = True then
     begin
   L4 := 16;  CheckBox21.checked := false;
   end
   else L4 := 0;

   PortCheck;
end;


procedure TForm2.CheckBox14Change(Sender: TObject);  //D5 unten
begin
   if CheckBox14.Checked = True then
     begin
     L5 := 32; CheckBox22.checked := false;
     end
     else L5 := 0;

   PortCheck;
end;

procedure TForm2.CheckBox15Change(Sender: TObject);  //D6 unten
begin
   if CheckBox15.Checked = True then
     begin
     L6 := 64;  CheckBox23.checked := false;
     end
     else L6 := 0;

   PortCheck;
end;

procedure TForm2.CheckBox16Change(Sender: TObject);    //D7 unten
begin
   if CheckBox16.Checked = True then
     begin
     L7 := 128;  CheckBox24.checked := false;
     end
     else L7 := 0;

   PortCheck;
end;

end.          //. = Programmende ..........................



