//code aus TPS1013 verbessert





void rotary7seg() {




//****************************** Pinkonfiguration anpassen ******************************

outconf = GPIO_OE;                                //pinconfiguration speichern

gpiopads[0] = GPIO0_PAD;                          //padkonfiguration speichern
gpiopads[1] = GPIO1_PAD;
gpiopads[2] = GPIO2_PAD;
gpiopads[3] = GPIO3_PAD;
gpiopads[4] = GPIO4_PAD;
gpiopads[5] = GPIO5_PAD;
gpiopads[6] = GPIO6_PAD;
gpiopads[7] = GPIO7_PAD;
gpiopads[8] = GPIO8_PAD;                          
gpiopads[9] = GPIO9_PAD;
gpiopads[10] = GPIO10_PAD;
gpiopads[11] = GPIO11_PAD;
gpiopads[12] = GPIO12_PAD;
gpiopads[13] = GPIO13_PAD;
gpiopads[14] = GPIO14_PAD;
gpiopads[15] = GPIO15_PAD;


GPIO_OE |= 0x00C43FFF;                            //pinconfiguration für 7-segment und rotary

GPIO0_PAD = 0x47; // output, 2 mA                 //2mA für 7-segment
GPIO1_PAD = 0x47; // output, 2 mA
GPIO2_PAD = 0x47; // output, 2 mA
GPIO3_PAD = 0x47; // output, 2 mA
GPIO4_PAD = 0x47; // output, 2 mA
GPIO5_PAD = 0x47; // output, 2 mA
GPIO6_PAD = 0x47; // output, 2 mA
GPIO7_PAD = 0x47; // output, 2 mA
GPIO10_PAD = 0x77; // output, 12 mA               //12mA für 7-segment gem. kathoden
GPIO11_PAD = 0x77; // output, 12 mA
GPIO12_PAD = 0x77; // output, 12 mA
GPIO13_PAD = 0x77; // output, 12 mA


//****************************** Programmadresse bearbeiten, Daten aus EEPROM laden ******************************

work= 1;                                          //steuervariable für eeprombearbeitung und oledcursor

while(GPIO_INTR2 & 0x00000001){                   //warten solange gpio16 low
  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  }                  
delay(10);

pradr = 0x00;                                     //programmadresse


while(work != 0){                                 //beginn arbeitsschleife

GPIO_INTR2 |= 0x00000004;                         //clr neg flanke gpio16 von taster
while((GPIO_INTR2 & 0x00000004) == 0){            //keine neg flanke gpio16 von taster

eeadr = 2 * pradr;                                //eepromadresse = 2 x programmadresse
cmdval = EEPROM.read(eeadr);                      //read kommandowert
eeadr ++;                                         //eepromadresse +1
datval = EEPROM.read(eeadr);                      //read datenwertwert

digit4 = pradr;                                   //pradr nibble low nach digit2
digit4 &= 0x0F;

digit5 = pradr >>4 ;                              //pradr nibble high nach digit3
digit5 &= 0x0F;

digit2 = cmdval;                                  //cmdval nibble low nach digit2
digit2 &= 0x0F;

digit3 = cmdval >>4;                              //cmdval nibble high nach digit3
digit3 &= 0x0F;

digit0 = datval;                                  //datval nibble low nach digit0
digit0 &= 0x0F;

digit1 = datval >>4;                              //datval nibble high nach digit1
digit1 &= 0x0F;

wrtdisp();                                        //ADR,CMD,DAT nach oled

GPIO_INTR2 |= 0x00400000;                         //clr neg flanke gpio21 von rotary
GPIO_INTR2 |= 0x00000040;                         //clr neg flanke gpio17 von rotary
GPIO_INTR2 |= 0x00000004;                         //clr neg flanke gpio16 von taster
while(((GPIO_INTR2 & 0x00400000) == 0) && ((GPIO_INTR2 & 0x00000040) == 0) && ((GPIO_INTR2 & 0x00000004) == 0)) {      //keine neg flanke gpio21, keine neg flanke gpio17, keine neg flanke gpio16
  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit5];               //segmente = pradr nibble high
  GPIO_OUT_CLR |= 0x0400;                         //kathode digit 3 = 0
  delay(1);

  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit4];               //segmente = pradr nibble low
  GPIO_OUT_CLR |= 0x0800;                         //kathode digit 2 = 0
  delay(1);
}

if(GPIO_INTR2 & 0x00000040){                      //wenn neg flanke gpio17 von rotary
if(GPIO_INTR2 & 0x00100000){pradr ++;}            //inc pradr wenn low an gpio21 von rotary
if(GPIO_INTR2 & 0x00200000){pradr --;}            //dec pradr wenn high an gpio21 von rotary
}
else if(GPIO_INTR2 & 0x00400000){pradr ++;}      //wenn neg flanke gpio14 von rotary

pradr &= 0x00FF;                                  //pradr maximalwert 0xFF

timeout = 0;

while((GPIO_INTR2 & 0x00000010) || (GPIO_INTR2 & 0x00100000)){         //zeitverzögerung wegen trägheit von rotary

  eeadr = 2 * pradr;                                //eepromadresse = 2 x programmadresse
  cmdval = EEPROM.read(eeadr);                      //read kommandowert
  eeadr ++;                                         //eepromadresse +1
  datval = EEPROM.read(eeadr);                      //read datenwertwert
  
  digit4 = pradr;                                   //pradr nibble low nach digit2
  digit4 &= 0x0F;
  
  digit5 = pradr >>4 ;                              //pradr nibble high nach digit3
  digit5 &= 0x0F;

  digit2 = cmdval;                                  //cmdval nibble low nach digit2
  digit2 &= 0x0F;

  digit3 = cmdval >>4;                              //cmdval nibble high nach digit3
  digit3 &= 0x0F;

  digit0 = datval;                                  //datval nibble low nach digit0
  digit0 &= 0x0F;

  digit1 = datval >>4;                              //datval nibble high nach digit1
  digit1 &= 0x0F;


  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit5];               //segmente = pradr nibble high
  GPIO_OUT_CLR |= 0x0400;                         //kathode digit 3 = 0
  delay(1);

  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit4];               //segmente = pradr nibble low
  GPIO_OUT_CLR |= 0x0800;                         //kathode digit 2 = 0
  delay(1);
  
  timeout ++;

  if(timeout >300){                              //langer tastendruck
    if(GPIO_INTR2 & 0x00000010){pradr += 0xF0;}  //gpio17 low    
    if(GPIO_INTR2 & 0x00100000){pradr -= 0xF0;}  //gpio21 low                                      
    pradr &= 0x00FF;                             //pradr maximalwert 0xFF
    timeout = 0;
    wrtdisp();                                   //ADR,CMD,DAT nach oled
  }

}

}


//****************************** Kommandowerte bearbeiten ******************************

work= 2;                                          //steuervariable für eeprombearbeitung und oledcursor

while(GPIO_INTR2 & 0x00000001){                   //warten solange gpio16 low
  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  }       
delay(10);
GPIO_INTR2 |= 0x00000004;                         //clr neg flanke gpio16 von taster
while((GPIO_INTR2 & 0x00000004) == 0){            //keine neg flanke gpio16 von taster

digit2 = cmdval;                                  //cmdval nibble low nach digit2
digit2 &= 0x0F;

digit3 = cmdval >>4;                              //cmdval nibble high nach digit3
digit3 &= 0x0F;

digit0 = datval;                                  //datval nibble low nach digit0
digit0 &= 0x0F;

digit1 = datval >>4;                              //datval nibble high nach digit1
digit1 &= 0x0F;

wrtdisp();                                        //ADR,CMD,DAT nach oled

GPIO_INTR2 |= 0x00400000;                         //clr neg flanke gpio21 von rotary
GPIO_INTR2 |= 0x00000040;                         //clr neg flanke gpio17 von rotary
GPIO_INTR2 |= 0x00000004;                         //clr neg flanke gpio16 von taster
while(((GPIO_INTR2 & 0x00400000) == 0) && ((GPIO_INTR2 & 0x00000040) == 0) && ((GPIO_INTR2 & 0x00000004) == 0)) {      //keine neg flanke gpio21, keine neg flanke gpio17, keine neg flanke gpio16
  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit3];               //segmente = cmdval nibble high
  GPIO_OUT_CLR |= 0x0400;                         //kathode digit 3 = 0
  delay(1);

  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit2];               //segmente = cmdval nibble low
  GPIO_OUT_SET |= 0x80;                           //Dezimalpunkt an
  GPIO_OUT_CLR |= 0x0800;                         //kathode digit 2 = 0
  delay(1);

  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit1];               //segmente = datval nibble high
  GPIO_OUT_CLR |= 0x1000;                         //kathode digit 3 = 0
  delay(1);

  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit0];               //segmente = datval nibble low
  GPIO_OUT_CLR |= 0x2000;                         //kathode digit 0 = 0
  delay(1);
}


if(GPIO_INTR2 & 0x00000040){                      //wenn neg flanke gpio17 von rotary
if(GPIO_INTR2 & 0x00100000){cmdval ++;}           //inc cmdval wenn low an gpio21 von rotary
if(GPIO_INTR2 & 0x00200000){cmdval --;}           //decc cmdval wenn low an gpio21 von rotary
}
else if(GPIO_INTR2 & 0x00400000){cmdval ++;}      //wenn neg flanke gpio21 von rotary


timeout = 0;

while((GPIO_INTR2 & 0x00000010) || (GPIO_INTR2 & 0x00100000)){         //zeitverzögerung wegen trägheit von rotary

  digit2 = cmdval;                                  //cmdval nibble low nach digit2
  digit2 &= 0x0F;
  
  digit3 = cmdval >>4;                              //cmdval nibble high nach digit3
  digit3 &= 0x0F;
  
  digit0 = datval;                                  //datval nibble low nach digit0
  digit0 &= 0x0F;
  
  digit1 = datval >>4;                              //datval nibble high nach digit1
  digit1 &= 0x0F;


  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit3];               //segmente = cmdval nibble high
  GPIO_OUT_CLR |= 0x0400;                         //kathode digit 3 = 0
  delay(1);

  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit2];               //segmente = cmdval nibble low
  GPIO_OUT_SET |= 0x80;                           //Dezimalpunkt an
  GPIO_OUT_CLR |= 0x0800;                         //kathode digit 2 = 0
  delay(1);

  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit1];               //segmente = datval nibble high
  GPIO_OUT_CLR |= 0x1000;                         //kathode digit 1 = 0
  delay(1);

  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit0];               //segmente = cmdval nibble low
  GPIO_OUT_CLR |= 0x2000;                         //kathode digit 0 = 0
  delay(1);


  timeout ++;

  if(timeout >160){                              //langer tastendruck
    if(GPIO_INTR2 & 0x00000010){cmdval += 0xF0;} //gpio17 low
    if(GPIO_INTR2 & 0x00100000){cmdval -= 0xF0;} //gpio21 low
    cmdval &= 0x00FF;                            //pradr maximalwert 0xFF
    timeout = 0;
    wrtdisp();                                   //ADR,CMD,DAT nach oled
  }
}

}



//****************************** Datenwerte bearbeiten ******************************

work= 3;                                          //steuervariable für eeprombearbeitung und oledcursor

while(GPIO_INTR2 & 0x00000001){                   //warten solange gpio16 low
  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  }       
delay(10);
GPIO_INTR2 |= 0x00000004;                         //clr neg flanke gpio16 von taster
while((GPIO_INTR2 & 0x00000004) == 0){            //keine neg flanke gpio16 von taster

digit2 = cmdval;                                  //cmdval nibble low nach digit2
digit2 &= 0x0F;

digit3 = cmdval >>4;                              //cmdval nibble high nach digit3
digit3 &= 0x0F;

digit0 = datval;                                  //datval nibble low nach digit0
digit0 &= 0x0F;

digit1 = datval >>4;                              //datval nibble high nach digit1
digit1 &= 0x0F;

wrtdisp();                                        //ADR,CMD,DAT nach oled

GPIO_INTR2 |= 0x00400000;                         //clr neg flanke gpio21 von rotary
GPIO_INTR2 |= 0x00000040;                         //clr neg flanke gpio17 von rotary
GPIO_INTR2 |= 0x00000004;                         //clr neg flanke gpio16 von taster
while(((GPIO_INTR2 & 0x00400000) == 0) && ((GPIO_INTR2 & 0x00000040) == 0) && ((GPIO_INTR2 & 0x00000004) == 0)) {      //keine neg flanke gpio21, keine neg flanke gpio17, keine neg flanke gpio16
  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit3];               //segmente = cmdval nibble high
  GPIO_OUT_CLR |= 0x0400;                         //kathode digit 3 = 0
  delay(1);

  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit2];               //segmente = cmdval nibble low
  GPIO_OUT_CLR |= 0x0800;                         //kathode digit 2 = 0
  delay(1);

  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit1];               //segmente = datval nibble high
  GPIO_OUT_CLR |= 0x1000;                         //kathode digit 3 = 0
  delay(1);

  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit0];               //segmente = datval nibble low
  GPIO_OUT_SET |= 0x80;                           //Dezimalpunkt an
  GPIO_OUT_CLR |= 0x2000;                         //kathode digit 0 = 0
  delay(1);
}


if(GPIO_INTR2 & 0x00000040){                      //wenn neg flanke gpio17 von rotary
if(GPIO_INTR2 & 0x00100000){datval ++;}           //inc datval wenn low an gpio21 von rotary
if(GPIO_INTR2 & 0x00200000){datval --;}           //decc datval wenn low an gpio21 von rotary
}
else if(GPIO_INTR2 & 0x00400000){datval ++;}      //wenn neg flanke gpio21 von rotary



timeout = 0;

while((GPIO_INTR2 & 0x00000010) || (GPIO_INTR2 & 0x00100000)){         //zeitverzögerung wegen trägheit von rotary

  digit2 = cmdval;                                  //cmdval nibble low nach digit2
  digit2 &= 0x0F;
  
  digit3 = cmdval >>4;                              //cmdval nibble high nach digit3
  digit3 &= 0x0F;
  
  digit0 = datval;                                  //datval nibble low nach digit0
  digit0 &= 0x0F;
  
  digit1 = datval >>4;                              //datval nibble high nach digit1
  digit1 &= 0x0F;

  
  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit3];               //segmente = cmdval nibble high
  GPIO_OUT_CLR |= 0x0400;                         //kathode digit 3 = 0
  delay(1);

  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit2];               //segmente = cmdval nibble low
  GPIO_OUT_CLR |= 0x0800;                         //kathode digit 2 = 0
  delay(1);

  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit1];               //segmente = datval nibble high
  GPIO_OUT_CLR |= 0x1000;                         //kathode digit 1 = 0
  delay(1);

  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  GPIO_OUT_CLR |= 0x00FF;                         //alle segmente = 0
  GPIO_OUT_SET |= segments[digit0];               //segmente = cmdval nibble low
  GPIO_OUT_SET |= 0x80;                           //Dezimalpunkt an
  GPIO_OUT_CLR |= 0x2000;                         //kathode digit 0 = 0
  delay(1);

  timeout ++;

  if(timeout >160){                              //langer tastendruck
    if(GPIO_INTR2 & 0x00000010){datval += 0xF0;} //gpio17 low
    if(GPIO_INTR2 & 0x00100000){datval -= 0xF0;} //gpio21 low
    datval &= 0x00FF;                            //pradr maximalwert 0xFF
    timeout = 0;
    wrtdisp();                                   //ADR,CMD,DAT nach oled
  }
  
}

}


//****************************** EEPROM-Werte speichern ******************************


delay(100);

eeadr = 2 * pradr;                                //eepromadresse berechnen
EEPROM.write(eeadr, cmdval);                      //kommandowert zum speichern vormerken
eeadr++;
EEPROM.write(eeadr, datval);                      //datenwert zum speichern vormerken

pradr ++;                                         //inc programmadresse


GPIO_OUT_CLR |= 0x00FF;                           //alle segmente = 0
GPIO_OUT_SET |= 0x80;                             //Dezimalpunkt an


zeit = 0;
display.clear();
display.display();
while(zeit < 300){                                //zeitschleife > 2,4 s für rückkehr zum hauptprogramm
  if(GPIO_INTR2 & 0x00000001){                    //wenn gpio16 low

    GPIO_OUT_SET |= 0x3C00;                       //alle kathoden = 1
    GPIO_OUT_CLR |= 0x2000;                       //kathode digit 0 = 0
    delay(2);
    
    GPIO_OUT_SET |= 0x3C00;                       //alle kathoden = 1
    GPIO_OUT_CLR |= 0x1000;                       //kathode digit 1 = 0
    delay(2);

    GPIO_OUT_SET |= 0x3C00;                       //alle kathoden = 1
    GPIO_OUT_CLR |= 0x0800;                       //kathode digit 2 = 0
    delay(2);
    
    GPIO_OUT_SET |= 0x3C00;                       //alle kathoden = 1
    GPIO_OUT_CLR |= 0x0400;                       //kathode digit 3 = 0
    delay(2);
    
    zeit ++;

    if(zeit == 50) {watdisp();}                   //waitanzeige
    
    } 
     
  else{zeit  = 600;}                              //gpio16 < 4 s low
}
display.clear();
display.display();
if(zeit != 600){work=0;}
else{work = 1;}                                   //wegen cursorsteuerung

while(GPIO_INTR2 & 0x00000001){                   //warten solange gpio16 low
  GPIO_OUT_SET |= 0x3C00;                         //alle kathoden = 1
  }                  



delay(10);

GPIO_INTR2 |= 0x00000004;                         //clr neg flanke gpio16 von taster
}                                                 //ende der work-schleife zurück zur nächsten programmadresse



//****************************** zurück zum Hauptprogramm ******************************

EEPROM.commit();                                  //werte in eeprom speichern


svddisp();
delay(1000);

GPIO_OUT_SET |= 0x3C00;                           //gem. kathoden = 1
GPIO_OUT_CLR |= 0x00FF;                           //segmente = 0

GPIO10_PAD = 0x80; // hochohmig                   //hochohmig alle 7-segment gem. kathoden
GPIO11_PAD = 0x80; // hochohmig
GPIO12_PAD = 0x80; // hochohmig
GPIO13_PAD = 0x80; // hochohmig

GPIO0_PAD = gpiopads[0];                          //padkonfiguration wiederherstellen
GPIO1_PAD = gpiopads[1];
GPIO2_PAD = gpiopads[2];
GPIO3_PAD = gpiopads[3];
GPIO4_PAD = gpiopads[4];
GPIO5_PAD = gpiopads[5];                          
GPIO6_PAD = gpiopads[6];
GPIO7_PAD = gpiopads[7];
GPIO8_PAD = gpiopads[8];                          
GPIO9_PAD = gpiopads[9];
GPIO10_PAD = gpiopads[10];
GPIO11_PAD = gpiopads[11];
GPIO12_PAD = gpiopads[12];
GPIO13_PAD = gpiopads[13];                          
GPIO14_PAD = gpiopads[14];
GPIO15_PAD = gpiopads[15];

GPIO_OE = outconf;                                //pinconfiguration wiederherstellen

GPIO_INTR2 |= 0x00400000;                         //clr neg flanke gpio21 von rotary
GPIO_INTR2 |= 0x00000040;                         //clr neg flanke gpio17 von rotary
GPIO_INTR2 |= 0x00000004;                         //clr neg flanke gpio16 von taster

rp2040.reboot();

delay(10);


} 





 
