//registers


#define MEM32(address) (*(volatile uint32_t*)(address))

//GPIO
#define GPIO_I MEM32(0xD0000004)
#define GPIO_OUT MEM32(0xD0000010)
#define GPIO_OUT_SET MEM32(0xD0000014)
#define GPIO_OUT_CLR MEM32(0xD0000018)
#define GPIO_OE MEM32(0xD0000020)
#define GPIO_OUT_XOR MEM32(0xD000001C)

#define GPIO_INTR0 MEM32(0x400140F0)
#define GPIO_INTR1 MEM32(0x400140F4)
#define GPIO_INTR2 MEM32(0x400140F8)
#define GPIO_INTR3 MEM32(0x400140FC)


#define GPIO_P0_INTE0 MEM32(0x40014100)
#define GPIO_P0_INTE1 MEM32(0x40014104)
#define GPIO_P0_INTE2 MEM32(0x40014108)
#define GPIO_P0_INTE3 MEM32(0x4001410C)

#define GPIO_P0_INTF0 MEM32(0x40014110)
#define GPIO_P0_INTF1 MEM32(0x40014114)
#define GPIO_P0_INTF2 MEM32(0x40014118)
#define GPIO_P0_INTF3 MEM32(0x4001411C)

#define GPIO_P0_INTS0 MEM32(0x40014120)
#define GPIO_P0_INTS1 MEM32(0x40014124)
#define GPIO_P0_INTS2 MEM32(0x40014128)
#define GPIO_P0_INTS3 MEM32(0x4001412C)

#define GPIO_P1_INTE0 MEM32(0x40014130)
#define GPIO_P1_INTE1 MEM32(0x40014134)
#define GPIO_P1_INTE2 MEM32(0x40014138)
#define GPIO_P1_INTE3 MEM32(0x4001413C)

#define GPIO_P1_INTF0 MEM32(0x40014140)
#define GPIO_P1_INTF1 MEM32(0x40014144)
#define GPIO_P1_INTF2 MEM32(0x40014148)
#define GPIO_P1_INTF3 MEM32(0x4001414C)

#define GPIO_P1_INTS0 MEM32(0x40014150)
#define GPIO_P1_INTS1 MEM32(0x40014154)
#define GPIO_P1_INTS2 MEM32(0x40014158)
#define GPIO_P1_INTS3 MEM32(0x4001415C)


#define GPIO0_CTRL MEM32(0x40014004)
#define GPIO1_CTRL MEM32(0x4001400C)
#define GPIO2_CTRL MEM32(0x40014014)
#define GPIO3_CTRL MEM32(0x4001401C)
#define GPIO4_CTRL MEM32(0x40014024)
#define GPIO5_CTRL MEM32(0x4001402C)
#define GPIO6_CTRL MEM32(0x40014034)
#define GPIO7_CTRL MEM32(0x4001403C)
#define GPIO8_CTRL MEM32(0x40014044)
#define GPIO9_CTRL MEM32(0x4001404C)
#define GPIO10_CTRL MEM32(0x40014054)
#define GPIO11_CTRL MEM32(0x4001405C)
#define GPIO12_CTRL MEM32(0x40014064)
#define GPIO13_CTRL MEM32(0x4001406C)
#define GPIO14_CTRL MEM32(0x40014074)
#define GPIO15_CTRL MEM32(0x4001407C)
#define GPIO16_CTRL MEM32(0x40014084)
#define GPIO17_CTRL MEM32(0x4001408C)
#define GPIO18_CTRL MEM32(0x40014094)
#define GPIO19_CTRL MEM32(0x4001409C)
#define GPIO20_CTRL MEM32(0x400140A4)
#define GPIO21_CTRL MEM32(0x400140AC)
#define GPIO22_CTRL MEM32(0x400140B4)
#define GPIO23_CTRL MEM32(0x400140BC)
#define GPIO26_CTRL MEM32(0x400140D4)
#define GPIO27_CTRL MEM32(0x400140DC)
#define GPIO28_CTRL MEM32(0x400140E4)


#define GPIO0_PAD MEM32(0x4001C004)
#define GPIO1_PAD MEM32(0x4001C008)
#define GPIO2_PAD MEM32(0x4001C00C)
#define GPIO3_PAD MEM32(0x4001C010)
#define GPIO4_PAD MEM32(0x4001C014)
#define GPIO5_PAD MEM32(0x4001C018)
#define GPIO6_PAD MEM32(0x4001C01C)
#define GPIO7_PAD MEM32(0x4001C020)
#define GPIO8_PAD MEM32(0x4001C024)
#define GPIO9_PAD MEM32(0x4001C028)
#define GPIO10_PAD MEM32(0x4001C02C)
#define GPIO11_PAD MEM32(0x4001C030)
#define GPIO12_PAD MEM32(0x4001C034)
#define GPIO13_PAD MEM32(0x4001C038)
#define GPIO14_PAD MEM32(0x4001C03C)
#define GPIO15_PAD MEM32(0x4001C040)
#define GPIO16_PAD MEM32(0x4001C044)
#define GPIO17_PAD MEM32(0x4001C048)
#define GPIO18_PAD MEM32(0x4001C04C)
#define GPIO19_PAD MEM32(0x4001C050)
#define GPIO20_PAD MEM32(0x4001C054)
#define GPIO21_PAD MEM32(0x4001C058)
#define GPIO22_PAD MEM32(0x4001C05C)
#define GPIO23_PAD MEM32(0x4001C060)
#define GPIO26_PAD MEM32(0x4001C06C)
#define GPIO27_PAD MEM32(0x4001C070)
#define GPIO28_PAD MEM32(0x4001C074)


//WATCHDOG
#define WDT_CTRL MEM32(0x40058000)
#define WDT_LOAD MEM32(0x40058004)
#define WDT_REASON MEM32(0x40058008)
#define WDT_SCRATCH0 MEM32(0x4005800C)
#define WDT_SCRATCH1 MEM32(0x40058010)
#define WDT_SCRATCH2 MEM32(0x40058014)
#define WDT_SCRATCH3 MEM32(0x40058018)
#define WDT_SCRATCH4 MEM32(0x4005801C)
#define WDT_SCRATCH5 MEM32(0x40058020)
#define WDT_SCRATCH6 MEM32(0x40058024)
#define WDT_SCRATCH7 MEM32(0x40058028)
#define WDT_TICK MEM32(0x4005802C)



void startup(){
GPIO_OE = 0x00FE3FFF; //outputs
//0b0000 0000 1111 1110 0011 1111 1111 1111

GPIO0_CTRL = 5; //SIO
GPIO1_CTRL = 5; //SIO
GPIO2_CTRL = 5; //SIO
GPIO3_CTRL = 5; //SIO
GPIO4_CTRL = 5; //SIO
GPIO5_CTRL = 5; //SIO
GPIO6_CTRL = 5; //SIO
GPIO7_CTRL = 5; //SIO
GPIO8_CTRL = 4; //PWM4A
GPIO9_CTRL = 4; //PWM4B
GPIO10_CTRL = 5; //SIO
GPIO11_CTRL = 5; //SIO
GPIO12_CTRL = 5; //SIO
GPIO13_CTRL = 5; //SIO
GPIO14_CTRL = 5; //SIO
GPIO15_CTRL = 5; //SIO
GPIO16_CTRL = 5; //SIO
GPIO17_CTRL = 5; //SIO
GPIO18_CTRL = 5; //SIO
GPIO19_CTRL = 5; //SIO
GPIO20_CTRL = 5; //SIO
GPIO21_CTRL = 5; //SIO
GPIO22_CTRL = 5; //SIO
GPIO23_CTRL = 5; //SIO
GPIO26_CTRL = 5; //SIO
GPIO27_CTRL = 5; //SIO
GPIO28_CTRL = 5; //SIO

/*
GPIO0_PAD = 0x47; // output, 2 mA
GPIO1_PAD = 0x47; // output, 2 mA
GPIO2_PAD = 0x47; // output, 2 mA
GPIO3_PAD = 0x47; // output, 2 mA
GPIO4_PAD = 0x47; // output, 2 mA
GPIO5_PAD = 0x47; // output, 2 mA
GPIO6_PAD = 0x47; // output, 2 mA
GPIO7_PAD = 0x47; // output, 2 mA
GPIO8_PAD = 0x57; // output, 4 mA
GPIO9_PAD = 0x57; // output, 4 mA
*/
GPIO10_PAD = 0x80; // hochohmig
GPIO11_PAD = 0x80; // hochohmig
GPIO12_PAD = 0x80; // hochohmig
GPIO13_PAD = 0x80; // hochohmig
GPIO14_PAD = 0x5A; // output disable, input enable, pullup, schmitt
GPIO15_PAD = 0x5A; // output disable, input enable, pullup, schmitt
GPIO16_PAD = 0x5A; // output disable, input enable, pullup, schmitt
GPIO17_PAD = 0x57; // output, 4 mA
GPIO18_PAD = 0x57; // output, 4 mA
GPIO19_PAD = 0x57; // output, 4 mA
GPIO20_PAD = 0x57; // output, 4 mA
GPIO21_PAD = 0x57; // output, 4 mA
GPIO22_PAD = 0x57; // output, 4 mA
GPIO23_PAD = 0x57; // output, 4 mA
GPIO26_PAD = 0x80; // disable digital input
GPIO27_PAD = 0x80; // disable digital input
GPIO28_PAD = 0x80; // disable digital input

GPIO_OUT_SET = 0x00800000;   //ripple reduce

}
