unit ClockIQ_2;

interface

uses D2XXUnit, RSCOM, 
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    FlashBin: TButton;
    ScrollBar1: TScrollBar;
    Freq: TLabel;
    RAMbin: TButton;
    ProgressBar1: TProgressBar;
    CMD1_4: TButton;
    CMD2_8: TButton;
    Cmd4_16: TButton;
    Cmd10_40: TButton;
    Cmd25_100: TButton;
    ScrollBar2: TScrollBar;
    Offset: TLabel;
    ScrollBar3: TScrollBar;
    Label7: TLabel;
    Xtal: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    SaveSetup: TButton;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    RadioButton7: TRadioButton;
    RadioButton8: TRadioButton;
    RadioButton9: TRadioButton;
    RadioButton11: TRadioButton;
    RadioButton12: TRadioButton;
    procedure FormCreate(Sender: TObject);
    procedure FlashBinClick(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure CMD1_4Click(Sender: TObject);
    procedure CMD2_8Click(Sender: TObject);
    procedure Cmd4_16Click(Sender: TObject);
    procedure Cmd10_40Click(Sender: TObject);
    procedure RAMbinClick(Sender: TObject);
    procedure FtoEEPROMClick(Sender: TObject);
    procedure Cmd25_100Click(Sender: TObject);
    procedure ScrollBar2Change(Sender: TObject);
    procedure Mux0Click(Sender: TObject);
    procedure Mux1Click(Sender: TObject);
    procedure Mux2Click(Sender: TObject);
    procedure db20Click(Sender: TObject);
    procedure db10Click(Sender: TObject);
    procedure db0Click(Sender: TObject);
    procedure Mux3Click(Sender: TObject);
    procedure ScrollBar3Change(Sender: TObject);
    procedure Mux4Click(Sender: TObject);
    procedure Mux5Click(Sender: TObject);
    procedure Mux6Click(Sender: TObject);
    procedure Mux7Click(Sender: TObject);
    procedure Edit6Change(Sender: TObject);
    procedure Edit7Change(Sender: TObject);
    procedure SaveSetupClick(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure RadioButton3Click(Sender: TObject);
    procedure RadioButton4Click(Sender: TObject);
    procedure RadioButton5Click(Sender: TObject);
    procedure RadioButton6Click(Sender: TObject);
    procedure RadioButton7Click(Sender: TObject);
    procedure RadioButton8Click(Sender: TObject);
    procedure RadioButton9Click(Sender: TObject);
    procedure RadioButton11Click(Sender: TObject);
    procedure RadioButton12Click(Sender: TObject);
  end;

var
  Form1: TForm1;
  COM: Integer = 1;
  Freq: Integer;
  Codearray : array [0..5000] of byte;
  Fehler: Boolean;
  P,Q,Div1N: Integer;
  var R40, R41, R42 : Integer;
  P0: Integer;
  IICadr,n: Integer;
  Step: Real;
  VFOhigh: Boolean;
  FT_port: Integer = 0;
  Buf_adr: Integer = 0;
  Mux: Integer;
  dB: Integer;
implementation


{$R *.DFM}
procedure SCL(d:Integer);
begin
  if COM < 11 then begin
     if d=1 then RTS (1) else RTS (0);
     Delay (0.01);
  end;
  If COM = 11 then begin   //UM232R
    if d=0 then FT_port := FT_port and (255-4) else FT_port := FT_port or (4); //Bit 2
    FT_Out_Buffer[Buf_adr] := FT_port;
    Buf_adr := Buf_adr +1;
  end;
  If COM = 12 then begin    //USB/Seriell-Adapter mit FT232
    if d=1 then FT_port := FT_port and (255-4) else FT_port := FT_port or (4); //Bit 2
    FT_Out_Buffer[Buf_adr] := FT_port;
    Buf_adr := Buf_adr +1;
  end;
end;

procedure SDA(d:Integer);
begin
  if COM < 11 then begin
     if d=1 then DTR (1) else DTR (0);
     Delay (0.01);
  end;
  if COM = 11 then begin    //UM232R
    if d=0 then FT_port := FT_port and (255-16) else FT_port := FT_port or (16); //Bit 2
    FT_Out_Buffer[Buf_adr] := FT_port;
    Buf_adr := Buf_adr +1;
  end;
  if COM = 12 then begin    //USB/Seriell-Adapter mit FT232
    if d=1 then FT_port := FT_port and (255-16) else FT_port := FT_port or (16); //Bit 2
    FT_Out_Buffer[Buf_adr] := FT_port;
    Buf_adr := Buf_adr +1;
  end;
end;


procedure I2C_Init;
begin
  SCL(1); SDA(1);          { SCL=1, SDA=1 }
end;

procedure Start;
begin
  SDA(0);          { SDA=0 }
  SCL(0);          { SCL=0 }
end;

procedure Stop;
begin
  SCL(0); SDA(0);  { SCL=0, SDA=0 }
  SCL(1);          { SCL=1 }
  SDA(1);          { SDA=1 }
end;

procedure Acknowledge;
begin
  SCL(0); SDA(0);  { SCL=0, SDA=0 }
  SCL(1);          { SCL=1 }
  SCL(0);          { SCL=0 }
end;

procedure KeinAcknowledge;
begin
  SCL(0); SDA(1);  { SCL=0, SDA=1 }
  SCL(1);          { SCL=1 }
  SCL(0);          { SCL=0 }
end;

Function Ausgeben (Wert : Byte): Boolean;
var Bitwert, n: Byte;
begin
  Ausgeben := true;
  Bitwert := 128;
  for n:= 1 to 8 do begin
    if (Wert and Bitwert) = Bitwert then SDA(1)
     else SDA(0);   { SDA setzen }
    SCL(1);         { SCL=1 }
    SCL(0);         { SCL=0 }
    Bitwert := Bitwert div 2;
  end;
  SDA(1);           { SDA=1 }
  SCL(1);           { SCL=1, SDA lesen }
  SCL(0);           { SCL=0 }
end;

procedure FreqRechnen(Freq: Integer);
var Qout,Pout : Integer;
    Min, VCO: Real;
begin
    if (Freq > 19) and (Freq < 60) then begin
      Div1N := round (2500 / Freq) + 128;
      p := 1000;
      q := 40;
  end;

  if (Freq > 59) and (Freq < 801) then begin
      Div1N := 125;
      p := Freq * 2;
      q := 40;
  end;
  if (Freq > 800) and (Freq < 2001) then begin
      Div1N := 50;
      p := Freq ;
      Q := 50;
  end;
  if (Freq > 2000) and (Freq < 4001) then begin
     Div1N := 25;
     Min := 10000;
     for Q := 100 downto 10 do begin
       for p := 500 to 2000 do begin
          VCO := 10000/Q*P;
          if (abs(4*Freq-VCO/Div1N)) < Min then begin
            Min := abs(4*Freq-VCO/Div1N);
            Qout := Q;
            Pout := P;
          end;
       end;
     end;
     Q := Qout;
     P := POut;
  end;
  if (Freq > 4000) and (Freq < 10001) then begin
     Div1N := 10;
     Min := 10000;
     for Q := 10 to 100 do begin
       for p := 500 to 2000 do begin
          VCO := 10000/Q*P;
          if abs(4*Freq-VCO/Div1N) < Min then begin
            Min := abs(4*Freq-VCO/Div1N);
            Qout := Q;
            Pout := P;
          end;
       end;
     end;
     Q := Qout;
     P := POut;
   end;
  if (Freq > 10000) and (Freq < 20001) then begin
     Div1N := 5;
     Min := 10000;
     for Q := 100 downto 10 do begin
       for p := 500 to 2000 do begin
          VCO := 10000/Q*P;
          if abs(4*Freq-VCO/Div1N) < Min then begin
            Min := abs(4*Freq-VCO/Div1N);
            Qout := Q;
            Pout := P;
          end;
       end;
     end;
     Q := Qout;
     P := POut;
   end;
   if (Freq > 20000) and (Freq < 30001) then begin
     Div1N := 4;
     Min := 10000;
     for Q := 100 downto 10 do begin
       for p := 500 to 2000 do begin
          VCO := 10000/Q*P;
          if abs(4*Freq-VCO/Div1N) < Min then begin
            Min := abs(4*Freq-VCO/Div1N);
            Qout := Q;
            Pout := P;
          end;
       end;
     end;
     Q := Qout;
     P := POut;
   end;


end;



procedure RAM();
var Pump: Integer;
begin
  Buf_adr :=0;
  IICadr:=210;
  Pump := 1;
  If P>479 then Pump := 2;
  If P>639 then Pump := 3;
  If P>799 then Pump := 4;
  P0:= P mod 2;
  R40 := (P div 2 -4 ) div 256 + 4 * Pump + 192;
  R41 := (P div 2 -4) and 255;
  R42 := q-2+128*P0;      //q+2=50, 10 MHz / 50 = 200 kHz
  if VFOhigh then R42 := 23+128*P0;      //q+2=25, 10 MHz / 25 = 400 kHz
  //Label2.caption :=IntToStr (P) + ' ' +IntToStr (R40) + ' '+   IntToStr (R41) + ' '+ IntToStr (R42) + ' ';
  I2C_Init;
  Start;
  Ausgeben (IICadr); {Adr 210, RAM}
  Ausgeben (64);       //Adr 40 hex
  Ausgeben (R40);
  Ausgeben (R41);
  Ausgeben (R42);
  Stop;
  Sleep (10);
  Start;
  Ausgeben (IICadr); {Adr 210, RAM}
  Ausgeben (12);       //Adr 0C hex
  Ausgeben (Div1N);    //DIV1N=50
  Stop;
  Start;
  Ausgeben (IICadr); {Adr 210, RAM}
  Ausgeben (19);       //Adr 13 hex
  //Ausgeben (155);    //DIV1N=50
  Ausgeben (Form1.Scrollbar3.position);    //DIV1N=50
  Stop;
  if COM > 10 then begin
    Open_USB_Device;
    Set_USB_Device_BitMode(21,1);
    FT_Current_Baud:=38400;
    Set_USB_Device_BaudRate;
    Write_USB_Device_Buffer( Buf_adr);
    Close_USB_Device;
  end;
end;


function HexToInt (Hexzahl: String): Byte;
var h, l: Byte;
begin
  h:= ord (Hexzahl[1])-48;
  if h>9 then h:=h-7;
  l:= ord (Hexzahl[2])-48;
  if l>9 then l:=l-7;
  Result := 16*h+l;
end;

function ByteToHex (Dat: Integer): String;
var   Hi, Lo: Integer;
      LoHex, HiHex: String;
begin
  Lo := Dat and 15;
  Hi := Dat div 16;
  if Hi > 9 then Hi := Hi + 7;
  HiHex := Chr (48+Hi);
  if Lo > 9 then Lo := Lo + 7;
  LoHex := Chr (48+Lo);
  Result := HiHex + LoHex;
end;



procedure ReadInit;
VAR  f :TextFile;
     r, n: Integer;
     Zeile: String;
begin
    AssignFile(f,'init.txt');
    {$I-} Reset(f); {$I+}
    r:=IOResult;
    IF r = 0 then begin
      Readln (f, Zeile);
      Form1.Edit6.text := Zeile;    //fmin
      Readln (f, Zeile);
      Form1.Edit7.text := Zeile;    //fmax
      Readln (f, Zeile);
      Form1.Edit1.text := Zeile;    //f1
      Readln (f, Zeile);
      Form1.Edit2.text := Zeile;    //f2
      Readln (f, Zeile);
      Form1.Edit3.text := Zeile;    //f3
      Readln (f, Zeile);
      Form1.Edit4.text := Zeile;    //f4
      Readln (f, Zeile);
      Form1.Edit5.text := Zeile;    //f5
      Readln (f, Zeile);
      val (Zeile, n, r);
      Freq := n;
      Form1.Scrollbar1.position := n;
       Readln (f, Zeile);
      val (Zeile, n, r);
      Form1.Scrollbar2.position := n;
       Readln (f, Zeile);
      val (Zeile, n, r);
      Form1.Scrollbar3.position := n;
      Readln (f, Zeile);
      val (Zeile, n, r);
      COM := n;
      if COM=1 then OpenCOM (pchar ('COM1:9600,N,8,1'));
      if COM=2 then OpenCOM (pchar ('COM2:9600,N,8,1'));
      if COM=3 then OpenCOM (pchar ('COM3:9600,N,8,1'));
      if COM=4 then OpenCOM (pchar ('COM4:9600,N,8,1'));
      if COM=5 then OpenCOM (pchar ('COM5:9600,N,8,1'));
      if COM=6 then OpenCOM (pchar ('COM6:9600,N,8,1'));
      if COM=7 then OpenCOM (pchar ('COM7:9600,N,8,1'));
      if COM=8 then OpenCOM (pchar ('COM8:9600,N,8,1'));
      if COM=9 then OpenCOM (pchar ('COM9:9600,N,8,1'));
      if COM=10 then OpenCOM (pchar ('COM10:9600,N,8,1'));
      CloseFile (f);
    end;
  end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  //Freq.caption :=  FloatToStr (Scrollbar1.position*Step / 4)+ ' kHz';
   Offset.caption := IntToStr (Scrollbar2.position);
  Scrollbar1.position := 6063;
  Freq.caption :=  FloatToStr (6075) + ' kHz';
  ReadInit();
  FT_port := 255;
  FreqRechnen (6060);
  RAM;
end;


procedure TForm1.FlashBinClick(Sender: TObject);
VAR  f :File of Byte;
     r,wert :Byte;
     Anzahl: Byte;
     Adresse, m, n, i : Word;
     MaxAdr: Word;
     Code: Byte;
begin
   OpenDialog1.FileName := '*.bin';
   OpenDiaLog1.Execute;
   if OpenDialog1.FileName > '' then begin
     AssignFile(f,OpenDialog1.Filename);
    {$I-} Reset(f); {$I+}
    r:=IOResult;
    IF r = 0 then begin
      Adresse :=0;
      while (not Eof (f)) and (Adresse < 256) do begin
        Read(f,Code);
        Codearray[Adresse] := Code;
        Adresse := Adresse + 1;
      end;
      CloseFile(f);
  IICadr:= 208;
  for n:= 0 to 15 do begin
  Buf_adr :=0;
  I2C_Init;
  Start;
  Ausgeben (IICadr); {Adr 210, RAM, Ack?}
  Ausgeben (n*16);
     for m:= 0 to 15 do begin
       Ausgeben (CodeArray[n*16+m]);
     end;
     Stop;
  if COM > 10 then begin
    Open_USB_Device;
    Set_USB_Device_BitMode(21,1);
    FT_Current_Baud:=38400;
    Set_USB_Device_BaudRate;
    Write_USB_Device_Buffer( Buf_adr);
    Close_USB_Device;
  end;

     ProgressBar1.Position := n*16+15;
     Sleep (200);
     ProgressBar1.Position := 0;
   end;
  end;
 end;
end;



procedure TForm1.ScrollBar1Change(Sender: TObject);
var  VCO, Ausgang: Real;
   F: Integer;
begin
  F :=Scrollbar1.position;
  FreqRechnen (F);
  if (F > 59) then Ausgang := 10000/Q*P/Div1N/4;
  if (F < 60) then Ausgang := 2500 /(Div1N and 127);
  Ausgang := round (Ausgang);
  Freq.caption :=  FloatToStr (Ausgang+ Scrollbar2.position) + ' kHz';
  RAM;
end;

procedure TForm1.CMD1_4Click(Sender: TObject);
var Freq,N: Integer;
begin
  val(edit1.text,Freq,N);
  if Scrollbar1.min > Freq then Scrollbar1.min := Freq-1;
  if Scrollbar1.max < Freq then Scrollbar1.max := Freq+1;
  Scrollbar1.position := Freq-Scrollbar2.position;
end;

procedure TForm1.CMD2_8Click(Sender: TObject);
var Freq,N: Integer;
begin
  val(edit2.text,Freq,N);
  if Scrollbar1.min > Freq then Scrollbar1.min := Freq-1;
  if Scrollbar1.max < Freq then Scrollbar1.max := Freq+1;
  Scrollbar1.position := Freq-Scrollbar2.position;
end;

procedure TForm1.Cmd4_16Click(Sender: TObject);
var Freq,N: Integer;
begin
  val(edit3.text,Freq,N);
  if Scrollbar1.min > Freq then Scrollbar1.min := Freq-1;
  if Scrollbar1.max < Freq then Scrollbar1.max := Freq+1;
  Scrollbar1.position := Freq-Scrollbar2.position;
end;

procedure TForm1.Cmd10_40Click(Sender: TObject);
var Freq,N: Integer;
begin
  val(edit4.text,Freq,N);
  if Scrollbar1.min > Freq then Scrollbar1.min := Freq-1;
  if Scrollbar1.max < Freq then Scrollbar1.max := Freq+1;
  Scrollbar1.position := Freq-Scrollbar2.position;
end;


procedure TForm1.Cmd25_100Click(Sender: TObject);
var Freq,N: Integer;
begin
  val(edit5.text,Freq,N);
  if Scrollbar1.min > Freq then Scrollbar1.min := Freq-1;
  if Scrollbar1.max < Freq then Scrollbar1.max := Freq+1;
  Scrollbar1.position := Freq-Scrollbar2.position;
end;

procedure TForm1.RAMbinClick(Sender: TObject);
VAR  f :File of Byte;
     r,wert :Byte;
     Anzahl: Byte;
     Adresse, m, n, i : Word;
     MaxAdr: Word;
     Code: Byte;
begin
   OpenDialog1.FileName := '*.bin';
   OpenDiaLog1.Execute;
   if OpenDialog1.FileName > '' then begin
     AssignFile(f,OpenDialog1.Filename);
    {$I-} Reset(f); {$I+}
    r:=IOResult;
    IF r = 0 then begin
      Adresse :=0;
      while (not Eof (f)) and (Adresse < 256) do begin
        Read(f,Code);
        Codearray[Adresse] := Code;
        Adresse := Adresse + 1;
      end;
      CloseFile(f);
  IICadr:= 210;
  for n:= 0 to 15 do begin
  Buf_adr :=0;
  I2C_Init;
  Start;
  Ausgeben (IICadr); {Adr 210, RAM, Ack?}
  Ausgeben (n*16);
     for m:= 0 to 15 do begin
       Ausgeben (CodeArray[n*16+m]);
     end;
   Stop;
  if COM > 10 then begin
    Open_USB_Device;
    Set_USB_Device_BitMode(21,1);
    FT_Current_Baud:=38400;
    Set_USB_Device_BaudRate;
    Write_USB_Device_Buffer( Buf_adr);
    Close_USB_Device;
  end;


     ProgressBar1.Position := n*16+15;
     Sleep (200);
     ProgressBar1.Position := 0;
   end;
  end;
 end;
end;


procedure TForm1.FtoEEPROMClick(Sender: TObject);
var Pump: Integer;
begin
  IICadr:=208;
  Pump := 1;
  If P>479 then Pump := 2;
  If P>639 then Pump := 3;
  If P>799 then Pump := 4;
  P0:= P mod 2;
  R40 := (P div 2 -4 ) div 256 + 4 * Pump + 192;
  R41 := (P div 2 -4) and 255;
  R42 := 48+128*P0;      //q+2=50, 10 MHz / 50 = 200 kHz
  if VFOhigh then R42 := 23+128*P0;      //q+2=25, 10 MHz / 25 = 400 kHz
  //Label2.caption :=IntToStr (P) + ' ' +IntToStr (R40) + ' '+   IntToStr (R41) + ' '+ IntToStr (R42) + ' ';
  Buf_adr :=0;
  I2C_Init;
  Start;
  Ausgeben (IICadr); {Adr 210, RAM}
  Ausgeben (64);       //Adr 40 hex
  Ausgeben (R40);
  Ausgeben (R41);
  Ausgeben (R42);
  Stop;
  if COM > 10 then begin
    Open_USB_Device;
    Set_USB_Device_BitMode(21,1);
    FT_Current_Baud:=38400;
    Set_USB_Device_BaudRate;
    Write_USB_Device_Buffer( Buf_adr);
    Close_USB_Device;
  end;
  Sleep (10);
  Buf_adr :=0;
  Start;
  Ausgeben (IICadr); {Adr 210, RAM}
  Ausgeben (12);       //Adr 0C hex
  Ausgeben (Div1N);    //DIV1N=50
  Stop;
  if COM > 10 then begin
    Open_USB_Device;
    Set_USB_Device_BitMode(21,1);
    FT_Current_Baud:=38400;
    Set_USB_Device_BaudRate;
    Write_USB_Device_Buffer( Buf_adr);
    Close_USB_Device;
  end;
  Sleep (10);
 end;



procedure TForm1.ScrollBar2Change(Sender: TObject);
var Ausgang : Real;
  F: Integer;
begin
  Offset.caption := IntToStr (Scrollbar2.position);
  F :=Scrollbar1.position;
  FreqRechnen (F);
  if (F > 59) then Ausgang := 10000/Q*P/Div1N/4;
  if (F < 60) then Ausgang := 2500 /(Div1N and 127);
  Ausgang := round (Ausgang);
  Freq.caption :=  FloatToStr (Ausgang+ Scrollbar2.position) + ' kHz';
  RAM;
end;


procedure TForm1.Mux0Click(Sender: TObject);
begin
  Mux := 0;
  FT_port :=  FT_port and $63;        //0,1 = I2C, 2,3,4=MUX, 5,6=Attenuator
  FT_port :=  FT_port + 4 * Mux;
  RAM;
end;

procedure TForm1.Mux1Click(Sender: TObject);
begin
  Mux := 1;
  FT_port :=  FT_port and $63;
  FT_port :=  FT_port + 4 * Mux;
  RAM;
end;

procedure TForm1.Mux2Click(Sender: TObject);
begin
  Mux := 2;
  FT_port :=  FT_port and $63;
  FT_port :=  FT_port + 4 * Mux;
  RAM;
end;

procedure TForm1.db20Click(Sender: TObject);
begin
  dB := 2;
  FT_port :=  FT_port and $1F;
  FT_port :=  FT_port + 32 * dB;
  RAM;
end;

procedure TForm1.db10Click(Sender: TObject);
begin
  dB := 1;
  FT_port :=  FT_port and $1F;
  FT_port :=  FT_port + 32 * dB;
  RAM;
end;

procedure TForm1.db0Click(Sender: TObject);
begin
  dB := 0;
  FT_port :=  FT_port and $1F;
  FT_port :=  FT_port + 32 * dB;
  RAM;
end;

procedure TForm1.Mux3Click(Sender: TObject);
begin
  Mux := 3;
  FT_port :=  FT_port and $63;
  FT_port :=  FT_port + 4 * Mux;
  RAM;
end;

procedure TForm1.ScrollBar3Change(Sender: TObject);
begin
 RAM;
end;

procedure TForm1.Mux4Click(Sender: TObject);
begin
  Mux := 4;
  FT_port :=  FT_port and $63;
  FT_port :=  FT_port + 4 * Mux;
  RAM;
end;

procedure TForm1.Mux5Click(Sender: TObject);
begin
  Mux := 5;
  FT_port :=  FT_port and $63;
  FT_port :=  FT_port + 4 * Mux;
  RAM;
end;

procedure TForm1.Mux6Click(Sender: TObject);
begin
  Mux := 6;
  FT_port :=  FT_port and $63;
  FT_port :=  FT_port + 4 * Mux;
  RAM;
end;

procedure TForm1.Mux7Click(Sender: TObject);
begin
  Mux := 7;
  FT_port :=  FT_port and $63;
  FT_port :=  FT_port + 4 * Mux;
  RAM;
end;

procedure TForm1.Edit6Change(Sender: TObject);
var min,n: Integer;
begin
  val (Edit6.text,Min,n);
  if min < 20 then min := 20;
  if Scrollbar1.max < min then Scrollbar1.max := min+1;
  if Scrollbar1.position < min then Scrollbar1.position := min;
  Scrollbar1.min := min;
end;

procedure TForm1.Edit7Change(Sender: TObject);
var max,n: Integer;
begin
  val (Edit7.text,Max,n);
  if max < 20 then max := 20;
  if Scrollbar1.min > max then Scrollbar1.min := max-1;
  if Scrollbar1.position > max then Scrollbar1.position := max;
  Scrollbar1.max := max;
end;

procedure TForm1.SaveSetupClick(Sender: TObject);
VAR  f :TextFile;
     r: Integer;
begin
    AssignFile(f,'init.txt');
    {$I-} rewrite (f); {$I+}
    r:=IOResult;
    IF r = 0 then begin
      writeln (f,Edit6.text);
      writeln (f,Edit7.text);
      writeln (f,Edit1.text);
      writeln (f,Edit2.text);
      writeln (f,Edit3.text);
      writeln (f,Edit4.text);
      writeln (f,Edit5.text);
      writeln (f,Scrollbar1.position);
      writeln (f,Scrollbar2.position);
      writeln (f,Scrollbar3.position);
      writeln (f,IntToStr(COM));
      CloseFile (f);
    end;
end;

procedure TForm1.RadioButton1Click(Sender: TObject);
begin
   CloseCOM;
   COM := 1;
   If (OpenCOM (pchar ('COM1:9600,N,8,1')))=0 then RadioButton1.Checked := false;
end;




procedure TForm1.RadioButton2Click(Sender: TObject);
begin
   CloseCOM;
   COM := 2;
   If (OpenCOM (pchar ('COM2:9600,N,8,1')))=0 then RadioButton2.Checked := false;
end;

procedure TForm1.RadioButton3Click(Sender: TObject);
begin
   CloseCOM;
   COM := 3;
   If (OpenCOM (pchar ('COM3:9600,N,8,1')))=0 then RadioButton3.Checked := false;
end;

procedure TForm1.RadioButton4Click(Sender: TObject);
begin
   CloseCOM;
   COM := 4;
   If (OpenCOM (pchar ('COM4:9600,N,8,1')))=0 then RadioButton4.Checked := false;
end;

procedure TForm1.RadioButton5Click(Sender: TObject);
begin
   CloseCOM;
   COM := 5;
   If (OpenCOM (pchar ('COM5:9600,N,8,1')))=0 then RadioButton5.Checked := false;
end;

procedure TForm1.RadioButton6Click(Sender: TObject);
begin
   CloseCOM;
   COM := 6;
   If (OpenCOM (pchar ('COM6:9600,N,8,1')))=0 then RadioButton6.Checked := false;
end;

procedure TForm1.RadioButton7Click(Sender: TObject);
begin
   CloseCOM;
   COM := 7;
   If (OpenCOM (pchar ('COM7:9600,N,8,1')))=0 then RadioButton7.Checked := false;
end;

procedure TForm1.RadioButton8Click(Sender: TObject);
begin
   CloseCOM;
   COM := 8;
   If (OpenCOM (pchar ('COM8:9600,N,8,1')))=0 then RadioButton8.Checked := false;
end;

procedure TForm1.RadioButton9Click(Sender: TObject);
begin
   CloseCOM;
   COM := 9;
   If (OpenCOM (pchar ('COM9:9600,N,8,1')))=0 then RadioButton9.Checked := false;
end;


procedure TForm1.RadioButton11Click(Sender: TObject);
begin
   CloseCOM;
   COM := 11;
end;

procedure TForm1.RadioButton12Click(Sender: TObject);
begin
   CloseCOM;
   COM := 12;
end;

end.
