'Bascom ATmega32, LCD, Memory und Tastenabfrage

$regfile = "m32def.dat"
$crystal = 11059200
$hwstack = 16
$swstack = 32
$framesize = 32
Baud = 9600

Declare Sub Test1
Declare Sub Test2
Declare Sub Test3
Declare Sub Test4

Dim Pwma As Integer
Dim Pwmb As Integer



'Config Timer0 = Timer , Prescale = 64
'Start Timer0

Config Lcdpin = Pin , Db4 = Portb.4 , Db5 = Portb.5 , Db6 = Portb.6 , Db7 = Portb.7 , E = Portb.3 , Rs = Portb.2
Config Lcd = 16 * 2

Initlcd
Cls
Locate 1 , 1
Lcd "AK Modul Bus"
Locate 2 , 1
Lcd "ES-M32"
Waitms 1500

S1 Alias Pind.2
S2 Alias Pind.3
S3 Alias Pind.6
S4 Alias Pind.7

Config Portd = &B00110000
Portd.2 = 1
Portd.3 = 1
Portd.6 = 1
Portd.7 = 1

Out1 Alias Portd.4
Out2 Alias Portd.5

Cls
Locate 1 , 1
Lcd "S1=PRG1 S2=PRG2"
Locate 2 , 1
Lcd "S3=PRG3 S4=PRG4"


Do
If S1 = 0 Then
  Cls
  Locate 1 , 1
  Lcd "Test1"
  Waitms 1000
  Test1
End If
  If S2 = 0 Then
  Cls
  Locate 1 , 1
  Lcd "Test2"
  Locate 2 , 1
  Waitms 1000
  Test2
End If
If S3 = 0 Then
  Cls
  Locate 1 , 1
  Lcd "Test3"
  Waitms 1000
  Test3
End If
If S4 = 0 Then
  Cls
  Locate 1 , 1
  Lcd "Test4"
  Waitms 1000
  Test4
End If
Waitms 30
Loop



Sub Test1
  Dim A(200) As Byte
  Dim N As Word
  For N = 1 To 200
    A(n) = Low(n)
  Next N
  For N = 1 To 200
    Print A(n)
     Cls
     Lcd A(n)
     Waitms 500
  Next N
  Do
  Loop
End Sub


Sub Test2
  Dim D As Word
  Dim U As Single
  Config Adc = Single , Prescaler = 64 , Reference = Off
  Start Adc
  Do
    D = Getadc(0)
    Locate 1 , 1
    Lcd "ADC0   "
    Lcd D
    Lcd "    "
    U = D / 1023
    U = U * 5
    Locate 2 , 1
    Lcd Fusing(u , "#.###")
    Lcd " V     "
    Waitms 500
  Loop
End Sub

Sub Test3
  Out1 = 0
  Out2 = 0
  Cls
  Locate 1 , 1
  Lcd "S1=LED1 S2=LED2"
  Locate 2 , 1
  Lcd "S3=LED1+2 S4=AUS"
  Do
    If S1 = 0 Then
      Out1 = 1
      Out2 = 0
    End If
    If S2 = 0 Then
      Out1 = 0
      Out2 = 1
    End If
    If S3 = 0 Then
      Out1 = 1
      Out2 = 1
    End If
    If S4 = 0 Then
      Out1 = 0
      Out2 = 0
    End If
    Waitms 10
  Loop
End Sub

Sub Test4
  Config Timer1 = Pwm , Prescale = 8 , Pwm = 10 , Compare A Pwm = Clear Down , Compare B Pwm = Clear Down
  Dim Pwmalta As Integer
  Dim Pwmaltb As Integer
  Pwma = 0
  Pwmb = 0
  Cls
  Do
    If S1 = 0 Then Pwma = Pwma + 1
    If Pwma > 1023 Then Pwma = 1023
    If S2 = 0 Then Pwma = Pwma - 1
    If Pwma < 0 Then Pwma = 0
    If S3 = 0 Then Pwmb = Pwmb + 1
    If Pwmb > 1023 Then Pwmb = 1023
    If S4 = 0 Then Pwmb = Pwmb - 1
    If Pwmb < 0 Then Pwmb = 0
    Waitms 20
    Pwm1b = Pwma
    Pwm1a = Pwmb
    If Pwma <> Pwmalta Then
    Locate 1 , 1
    Lcd "LED1     "
    Locate 1 , 6
    Lcd Pwma
    End If
    Pwmalta = Pwma
    If Pwmb <> Pwmaltb Then
    Locate 2 , 1
    Lcd "LED2     "
    Locate 2 , 6
    Lcd Pwmb
    End If
    Pwmaltb = Pwmb
  Loop
End Sub

End