'Bascom ATmega32, LCD, Memory und Tastenabfrage

$regfile = "m32def.dat"
$crystal = 11059200
$hwstack = 16
$swstack = 32
$framesize = 32
Baud = 9600

Declare Sub Test1
Declare Sub Test2
Declare Sub Test3
Declare Sub Test4

Dim Pwma As Integer
Dim Pwmb As Integer
Dim N As Integer
Dim I As Integer
Dim D As Word
Dim U As Single
Dim B As Byte


'Config Timer0 = Timer , Prescale = 64
'Start Timer0

Config Lcdpin = Pin , Db4 = Portb.4 , Db5 = Portb.5 , Db6 = Portb.6 , Db7 = Portb.7 , E = Portb.3 , Rs = Portb.2
Config Lcd = 16 * 2

Initlcd
Cls
Locate 1 , 1
Lcd "Data logger"
Waitms 1500

Config Adc = Single , Prescaler = 64 , Reference = Off
Start Adc

S1 Alias Pind.2
S2 Alias Pind.3
S3 Alias Pind.6
S4 Alias Pind.7

Config Portd = &B00110000
Portd.2 = 1
Portd.3 = 1
Portd.6 = 1
Portd.7 = 1

Out1 Alias Portd.4
Out2 Alias Portd.5

Cls
Locate 1 , 1
Lcd "S1=Start S2=Stop"
Locate 2 , 1
Lcd "S3=Load S4=Clear"


Do
If S1 = 0 Then
  Cls
  Locate 1 , 1
  Lcd "Logger"
  Waitms 1000
  Test1
End If
  If S2 = 0 Then
  Cls
  Locate 1 , 1
  Lcd "Stop"
  Locate 2 , 1
  Waitms 1000
  Test2
End If
If S3 = 0 Then
  Cls
  Locate 1 , 1
  Lcd "Load"
  Waitms 1000
  Test3
End If
If S4 = 0 Then
  Cls
  Locate 1 , 1
  Lcd "Clear"
  Waitms 1000
  Test4
End If
Waitms 30
Loop



Sub Test1
  For N = 1 To 1000
    D = Getadc(1)
    U = D / 1023
    U = U * 5
    Locate 2 , 1
    Lcd Fusing(u , "#.###")
    Lcd " V"
    D = D / 4
    B = D
    Writeeeprom B , N
    Print B
    For I = 1 To 60
      Waitms 1000
      If S2 = 0 Then Exit Sub
    Next I
  Next N
End Sub


Sub Test2
  Locate 1 , 1
  Lcd "Stop   "
End Sub

Sub Test3
  Locate 1 , 1
  Lcd "Load   "
  For N = 1 To 1000
    Readeeprom B , N
    If B = 255 Then Exit Sub
    Print B
    Waitms 10
  Next N
End Sub

Sub Test4
  For N = 1 To 1000
    B = 255
    Writeeeprom B , N
  Next N
End Sub

End