/***********************************************************************/
/*                                                                     */
/*  FILE        :oszi_13.c                                             */
/*  DATE        :Wed, Nov 23, 2005                                     */
/*  DESCRIPTION :Main Program                                          */
/*  CPU TYPE    :Other                                                 */
/*  This file is generated by Renesas Project Generator (Ver.4.0).     */
/*  This file is generated by Renesas Project Generator (Ver.4.0).     */
/*                                                                     */
/*  Einkanal-Scope, R8C/13, 20 MHz, 38400 Baud, 10 Bit, 250 Messungen  */
/*                                                                     */
/***********************************************************************/
                  


#include "sfr_r813.h";                  

unsigned char ad_buf[500];


/************************************************************************************
Name:        sfr_init
Parameters:  None
Returns:     None
Description: Initial setting of SFR registers
************************************************************************************/
void sfr_init(void){

   /* Setting port registers */
   /* Clock synchronous serial I/O setting */
	
    u1brg = 32-1;	// 38400:0x17, 9600:0x2F (64+1) =  7.372.800 / 16 / 9600 UART0 auf 9600 Baud bei 7,3 MHz (Fehler ist ?)
	u1mr = 0x05;	// 0000.0101 UART1: 8bit; int. CLK; 1 Stop Bit; No parity; No Sleep
					// || | |^^^ 	8 Bit
					// || | ^  	Interne Clock
					// || ^		1 Stop Bit
					// |^		Paritt ausgeschaltet
					// ^		Sleep Mode deaktiviert 

	u1c0 = 0x00;	// 0000.0000 UART1: f1 as CLK; CTS, RTS disabled
					// ||||   ^^ 	f1 is selected as clock
					//    ^    	write 0




	u1c1 = 0x05;	// 0000.0101 UART1: Rx, TX enabled,   00000101
					//       | ^ 	Tx enabled
					//       ^    	Rx enabled

	txd1sel=1;
	ucon = 0x20;	//  P00=RXD11,  00100100, 00100000

}


void sendTxd1(unsigned char data)
{
	while (ti_u1c1 == 0);	//Wait for transmission buffer emty
	u1tb = data;       	// Set transmission data 
    te_u1c1 = 1;        	// Transmission enabled 
}

unsigned char receiveRxd1 (void)
{
	unsigned char data;
	unsigned char dummy;
	while (ir_s1ric == 0); 	//Wait for received data
    ir_s1ric = 0;    		//Clear serial reception flag 
	data = u1rbl;     		// Get reception data 
	dummy = u1rbh;     		// Get error 
	re_u1c1 = 1;      		// Reception enabled 

	return data;
}



unsigned int ad_in(unsigned char ch)
{
    /* Set A/D control registers */
    adcon0 = 0x94 + ch;      				//ADN8...AN11 an P1_0...P1_3               /* Analog input pin : AN0 is selected */
    adcon1 = 0x28;                          /* 10-bit mode */
    adst = 1;                               /* Conversion start */
    while(adst == 1){}                      /* Wait A/D conversion */
    return ad;                   /* return AD value */
}

void messung(void)
{
	unsigned int adr;
	for (adr = 0; adr < 500; adr++)
	{
		ad_buf[adr] = (ad_in(0))/4;
	}	 
	for (adr = 0; adr < 500; adr++)
	{
		sendTxd1(ad_buf[adr]);
	}	 
}

void main(void)
{
    /*-------------------------------------------------
    -  Change on-chip oscillator clock to Main clock  -
    -------------------------------------------------*/

    prc0 = 1;           	/* Protect off */
    cm13 = 1;           	/* Xin Xout */
    cm15 = 1;           	/* XCIN-XCOUT drive capacity select bit : HIGH */
    cm05 = 0;           	/* Xin on */
    cm16 = 0;           	/* Main clock = No division mode */
    cm17 = 0;
    cm06 = 0;           	/* CM16 and CM17 enable */
    asm("nop");         	/* Waiting for stable of oscillation */
    asm("nop");
    asm("nop");
    asm("nop");
    ocd2 = 0;           	/* Main clock change */
    prc0 = 0;           	/* Protect on */
	sfr_init();  

	while (1)
	{  
	   receiveRxd1();
	   messung();
	}
}

