unit SI4735Delphi1;

interface

uses D2XXUnit,  RSCOM,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Edit1: TEdit;
    Button3: TButton;
    Button4: TButton;
    Edit2: TEdit;
    Button5: TButton;
    Edit3: TEdit;
    Edit4: TEdit;
    Button6: TButton;
    Edit5: TEdit;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Timer1: TTimer;
    Button10: TButton;
    Edit6: TEdit;
    Button11: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);

  end;

var
 Form1: TForm1;
 COM: Integer = 2;
 Codearray : array [0..5000] of byte;
 Fehler: Boolean;
 FT_port: Integer = 7;
 Buf_adr: Integer = 0;
 R: array [0..10] of Byte;

implementation

{$R *.DFM}
procedure SCL(d:Integer);
begin
  if d=0 then FT_port := FT_port and (255-4) else FT_port := FT_port or (4); //Bit 2 RTS
  FT_Out_Buffer[Buf_adr] := FT_port;
  Buf_adr := Buf_adr +1;
end;

procedure SDA(d:Integer);
begin
  if d=0 then FT_port := FT_port and (255-16) else FT_port := FT_port or (16); //Bit 1 DTR
  //FT_port := FT_port and (255-16); //Bit 4
  //FT_port := FT_port + d * 16;
  FT_Out_Buffer[Buf_adr] := FT_port;
  Buf_adr := Buf_adr +1;
end;


procedure I2C_Init;
begin
  Buf_adr :=0;
  SCL(1); SDA(1);          { SCL=1, SDA=1 }
end;

procedure Start;
begin
  SDA(0);          { SDA=0 }
  SCL(0);          { SCL=0 }
end;

procedure Stop;
begin
  SCL(0); SDA(0);  { SCL=0, SDA=0 }
  SCL(1);          { SCL=1 }
  SDA(1);          { SDA=1 }
end;

procedure Acknowledge;
begin
  SCL(0); SDA(0);  { SCL=0, SDA=0 }
  SCL(1);          { SCL=1 }
  SCL(0);          { SCL=0 }
end;

procedure KeinAcknowledge;
begin
  SCL(0); SDA(1);  { SCL=0, SDA=1 }
  SCL(1);          { SCL=1 }
  SCL(0);          { SCL=0 }
end;

Function Ausgeben (Wert : Byte): Boolean;
var Bitwert, n: Byte;
begin
  Ausgeben := true;
  Bitwert := 128;
  for n:= 1 to 8 do begin
    if (Wert and Bitwert) = Bitwert then SDA(1)
     else SDA(0);   { SDA setzen }
    SCL(1);         { SCL=1 }
    SCL(0);         { SCL=0 }
    Bitwert := Bitwert div 2;
  end;
  SDA(1);           { SDA=1 }
  SCL(1);           { SCL=1, SDA lesen }
  SCL(0);           { SCL=0 }
end;

procedure I2Cbitbang();
begin
  Open_USB_Device;
  Set_USB_Device_BitMode(21,1);
  FT_Current_Baud:=4800;
  Set_USB_Device_BaudRate;
  Write_USB_Device_Buffer( Buf_adr);
  Close_USB_Device;
end;


function Readi2c(Ack: Byte): byte;
var
  n: Byte;
  d: Byte;
begin
  Buf_adr :=0;
  SDA(1);
  for n:= 1 to 8 do begin
     SCL(1);
     SCL(0);
  end;
  SDA(Ack);
  SCL(1);
  SCL(0);
  Open_USB_Device;
  Set_USB_Device_BitMode(21,4);      //sync bit bang      4
  FT_Current_Baud:=9600;
  Set_USB_Device_BaudRate;
  Write_USB_Device_Buffer( Buf_adr);
  Read_USB_Device_Buffer( Buf_adr);
  d :=0;
  for n := 1 to 8 do begin
   d:=d*2;
   if  (FT_In_Buffer[0+2*n] and 8) > 0 then d := d + 1;     //
  end;
  Close_USB_Device;
  Readi2c := d;
end;



function HexToInt (Hexzahl: String): Byte;
var h, l: Byte;
begin
  h:= ord (Hexzahl[1])-48;
  if h>9 then h:=h-7;
  l:= ord (Hexzahl[2])-48;
  if l>9 then l:=l-7;
  Result := 16*h+l;
end;

function ByteToHex (Dat: Integer): String;
var   Hi, Lo: Integer;
      LoHex, HiHex: String;
begin
  Lo := Dat and 15;
  Hi := Dat div 16;
  if Hi > 9 then Hi := Hi + 7;
  HiHex := Chr (48+Hi);
  if Lo > 9 then Lo := Lo + 7;
  LoHex := Chr (48+Lo);
  Result := HiHex + LoHex;
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  FT_port := 21;        //0=TXD,Reset, 2=DTR = SDA,2 = RTS=SCL
  TIMEINIT;
end;



procedure Prop(Adr: Word; Data : Word);
begin
  I2C_Init;
  Start;
  Ausgeben (34);
  Ausgeben ($12);
  Ausgeben ($00);
  Ausgeben (hi(Adr));
  Ausgeben (lo(Adr));
  Ausgeben (hi(Data));
  Ausgeben (lo(Data));
  Stop;
  I2Cbitbang;
  DELAY (1);
end;



procedure Xtal();
begin
    Prop ($0202, 125);   //4 MHz / 125 = 32 kHz
  DELAY (10);
    Prop ($0201, 32000);
    //DELAY (100);
end;

procedure PowerDown();
begin
  I2C_Init;
  Start;
  Ausgeben (34);
  Ausgeben ($11);
  Stop;
  I2Cbitbang;
  DELAY(10);
end;

procedure Init_AM();
begin
  I2C_Init;
  Start;
  Ausgeben (34);
  Ausgeben ($01);
  Ausgeben ($01);
  Ausgeben ($05);
  Stop;
  I2Cbitbang;
  DELAY (550);
end;

procedure AM_Tune_Freq(f: Word);
begin
  I2C_Init;
  Start;
  Ausgeben (34);
  Ausgeben ($40);
  Ausgeben ($00);
  Ausgeben (hi(f));
  Ausgeben (lo(f));
  Ausgeben ($00);
  Ausgeben ($00);
  Stop;
  I2Cbitbang;
  DELAY (250);
end;

procedure AM_Seek_Freq(Arg1: Byte);
begin
  I2C_Init;
  Start;
  Ausgeben (34);
  Ausgeben ($41);
  Ausgeben (Arg1);
  Stop;
  I2Cbitbang;
end;


procedure GET_INT_STATUS();
begin
  I2C_Init;
  Start;
  Ausgeben (34);
  Ausgeben ($14);
  Stop;
  Start;
  Ausgeben (35);
  I2Cbitbang;
  R[1]:= Readi2c(0);   //Ack
  R[2]:= Readi2c(0);
  R[3]:= Readi2c(0);
  R[4]:= Readi2c(0);
  R[5]:= Readi2c(1);   //Nack
  Buf_adr :=0;
  Stop;
  I2Cbitbang;
end;

procedure AM_Tune_Status();
begin
  I2C_Init;
  Start;
  Ausgeben (34);
  Ausgeben ($42);
  Ausgeben ($00);
  Stop;
  Start;
  Ausgeben (35);
  I2Cbitbang;
  R[0]:= Readi2c(0);   //Ack
  R[1]:= Readi2c(0);
  R[2]:= Readi2c(0);
  R[3]:= Readi2c(0);
  R[4]:= Readi2c(0);
  R[5]:= Readi2c(0);
  R[6]:= Readi2c(0);
  R[7]:= Readi2c(0);   //Nack
  R[8]:= Readi2c(1);   //Nack
  Buf_adr :=0;
  Stop;
  I2Cbitbang;
end;

procedure AM_RSQ_Status();
begin
  I2C_Init;
  Start;
  Ausgeben (34);
  Ausgeben ($43);
  Ausgeben ($00);
  Stop;
  Start;
  Ausgeben (35);
  I2Cbitbang;
  R[0]:= Readi2c(0);
  R[1]:= Readi2c(0);
  R[2]:= Readi2c(0);
  R[3]:= Readi2c(0);
  R[4]:= Readi2c(0);
  R[5]:= Readi2c(1);
  Buf_adr :=0;
  Stop;
  I2Cbitbang;
end;


procedure SPIinout ( Wert : Byte );
var Stelle, n : Integer;
begin
  Buf_adr := 0;
  FT_port := 0;
  FT_Out_Buffer[Buf_adr] := FT_port;    //unverndert
  Buf_adr := Buf_adr +1;
  Stelle := 128;         {MSB zuerst}
  for n:=1 to 8 do begin
    if ((Wert AND Stelle) > 0) then
      //MOSI(1)             { Daten an MOSI  }
      //else MOSI(0);
   // SCK (1);             { Clock  }
    Stelle := Stelle div 2;
    //SCK (0);             { Clock aus  }
  end;
  Open_USB_Device;
  Set_USB_Device_BitMode(200,4);      //sync bit bang
  FT_Current_Baud:=9600;
  Set_USB_Device_BaudRate;
  Write_USB_Device_Buffer( Buf_adr);
  Read_USB_Device_Buffer( Buf_adr);
  //Echo := 0;
  for n := 0 to 7 do begin
   //Echo := Echo * 2;
   //if  (FT_In_Buffer[3+3*n] and 32) > 0 then echo := echo + 1;
  end;
  Close_USB_Device;
end;







procedure TForm1.Button1Click(Sender: TObject);
begin
  Init_AM;
  DELAY (200);
  Xtal;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 PowerDown;
 
end;

procedure TForm1.Button3Click(Sender: TObject);
var f: Word;
   Code: Integer;
begin
  val (edit1.text,f,Code);
  AM_Tune_Freq(f);
  //timer1.enabled := true;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
    Open_USB_Device;
    Set_USB_Device_BitMode(200,0);      // bit bang ende
    Close_USB_Device;

end;


procedure TForm1.Button5Click(Sender: TObject);
begin
  AM_RSQ_Status;
  Edit2.text := IntToStr (R[1]) + ' ' +   IntToStr (R[2]) +  ' ' +IntToStr (R[3]) +  ' ' +IntToStr (R[4]) +  ' ' +IntToStr (R[5]) +  ' '+IntToStr (R[6])   +  ' '+IntToStr (R[7]) ;
  Edit3.text := IntToStr (R[4]) + ' dBuV';
  Edit4.text := IntToStr (R[5]) + ' dB SNR'
  end;

procedure TForm1.Button6Click(Sender: TObject);
var f, c: Word;
  cap: real;
begin
  AM_Tune_Status;
  f := 256* R[2] + R[3];
  Edit1.text := IntToStr (f);
  Edit2.text := IntToStr (R[1]) + ' ' +   IntToStr (R[2]) +  ' ' +IntToStr (R[3]) +  ' ' +IntToStr (R[4]) +  ' ' +IntToStr (R[5]) +  ' '+IntToStr (R[6])   +  ' '+IntToStr (R[7]) ;
  c := 256 * R[6] + R[7];
  cap := c * 0.095 + 7;
  c := round (cap);
  Edit5.text := IntToStr (c)+ ' pF' ;
end;

procedure TForm1.Button7Click(Sender: TObject);
var f: Word;
   Code: Integer;
begin
  val (edit1.text,f,Code);

  If f < 2300 Then Prop ($03402, 9);   //9 kHz Weite beim Suchen
  If f > 2300 Then Prop ($03402, 5);   //5 kHz Weite beim Suchen
  If f < 500 Then Prop ($03402, 1);    //1 kHz Weite beim Suchen
  AM_Seek_Freq(10);
end;

procedure TForm1.Button8Click(Sender: TObject);
var f: Word;
   Code: Integer;
begin
  val (edit1.text,f,Code);
  If f < 2300 Then Prop ($03402, 9);   //9 kHz Weite beim Suchen
  If f > 2300 Then Prop ($03402, 5);   //5 kHz Weite beim Suchen
  If f < 500 Then Prop ($03402, 1);    //1 kHz Weite beim Suchen
  AM_Seek_Freq(2);
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
 GET_INT_Status;
 Edit2.text := IntToStr (R[1]) + ' ' +   IntToStr (R[2]) +  ' ' +IntToStr (R[3]) +  ' ' +IntToStr (R[4]) +  ' ' +IntToStr (R[5]) +  ' '+IntToStr (R[6])   +  ' '+IntToStr (R[7]) ;

end;

procedure TForm1.Timer1Timer(Sender: TObject);
var f, c: Word;
  cap: real;
begin
  Delay (20);
  AM_Tune_Status;
  f := 256* R[2] + R[3];
  Edit6.text := IntToStr (f);
  c := 256 * R[6] + R[7];
  cap := c * 0.095 + 7;
  c := round (cap);
  Edit5.text := IntToStr (c)+ ' pF' ;
  Delay (20);
  AM_RSQ_Status;
  Edit2.text := IntToStr (R[1]) + ' ' +   IntToStr (R[2]) +  ' ' +IntToStr (R[3]) +  ' ' +IntToStr (R[4]) +  ' ' +IntToStr (R[5]) +  ' '+IntToStr (R[6])   +  ' '+IntToStr (R[7]) ;
  Edit3.text := IntToStr (R[4]) + ' dBuV';
  Edit4.text := IntToStr (R[5]) + ' dB SNR';
  Delay (20);
end;



procedure TForm1.Button10Click(Sender: TObject);
begin
 timer1.enabled := true;
end;

procedure TForm1.Button11Click(Sender: TObject);
begin
 timer1.enabled := false;
end;

end.
