unit SI4735Delphi5;

interface

uses D2XXUnit,  RSCOM,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, jpeg;

type
  TForm1 = class(TForm)
    TabControl1: TTabControl;
    PanelFM: TPanel;
    PanelAM: TPanel;
    Edit1: TEdit;
    Button3: TButton;
    Button7: TButton;
    Button8: TButton;
    Button5: TButton;
    Edit3: TEdit;
    Edit4: TEdit;
    Timer1: TTimer;
    ScrollBar1: TScrollBar;
    Vol: TLabel;
    Edit5: TEdit;
    ScrollBar2: TScrollBar;
    Volfm: TLabel;
    Edit2: TEdit;
    Button9: TButton;
    Timer2: TTimer;
    Button13: TButton;
    Button14: TButton;
    Edit6: TEdit;
    Edit7: TEdit;
    Button15: TButton;
    PanelStart: TPanel;
    Image1: TImage;
    RDS: TButton;
    Edit8: TEdit;
    Timer3: TTimer;
    Edit9: TEdit;
    RDSstop: TButton;
    Button1: TButton;
    Edit10: TEdit;
    Edit11: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure RDSClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure TabControl1Change(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure ScrollBar2Change(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure Timer3Timer(Sender: TObject);
    procedure RDSstopClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);


  end;

var
 Form1: TForm1;
 COM: Integer = 2;
 Codearray : array [0..500] of byte;
 Codearray2 : array [0..500] of byte;
 Fehler: Boolean;
 FT_port: Integer = 7;
 Buf_adr: Integer = 0;
 R: array [0..13] of Byte;
 DataOut: array [0..13] of Byte;
 f_alt: Integer;
 f: Integer;
 c: Integer;
 Code: Integer;
 cap: real;
 rdsaktiv, Zeit, UTCoffset, Minuten, Stunden: Integer;

implementation

{$R *.DFM}
procedure SCL(d:Integer);
begin
  if d=0 then FT_port := FT_port and (255-4) else FT_port := FT_port or (4); //Bit 2 RTS
  FT_Out_Buffer[Buf_adr] := FT_port;
  Buf_adr := Buf_adr +1;
end;

procedure SDA(d:Integer);
begin
  if d=0 then FT_port := FT_port and (255-16) else FT_port := FT_port or (16); //Bit 1 DTR
  //FT_port := FT_port and (255-16); //Bit 4
  //FT_port := FT_port + d * 16;
  FT_Out_Buffer[Buf_adr] := FT_port;
  Buf_adr := Buf_adr +1;
end;


procedure I2C_Init;
begin
  Buf_adr :=0;
  SCL(1); SDA(1);          { SCL=1, SDA=1 }
end;

procedure Start;
begin
  SDA(0);          { SDA=0 }
  SCL(0);          { SCL=0 }
end;

procedure Stop;
begin
  SCL(0); SDA(0);  { SCL=0, SDA=0 }
  SCL(1);          { SCL=1 }
  SDA(1);          { SDA=1 }
end;

procedure Acknowledge;
begin
  SCL(0); SDA(0);  { SCL=0, SDA=0 }
  SCL(1);          { SCL=1 }
  SCL(0);          { SCL=0 }
end;

procedure KeinAcknowledge;
begin
  SCL(0); SDA(1);  { SCL=0, SDA=1 }
  SCL(1);          { SCL=1 }
  SCL(0);          { SCL=0 }
end;

procedure ChipReset;
begin
  FT_Out_Buffer[0] := 20;
  Buf_adr := 1;
  Write_USB_Device_Buffer( Buf_adr);
  Read_USB_Device_Buffer( Buf_adr);
  Delay (10);
  FT_Out_Buffer[0] := 21;
  Buf_adr := 1;
  Write_USB_Device_Buffer( Buf_adr);
  Read_USB_Device_Buffer( Buf_adr);
  Delay (10);
end;


Function Ausgeben (Wert : Byte): Boolean;
var Bitwert, n: Byte;
begin
  Ausgeben := true;
  Bitwert := 128;
  for n:= 1 to 8 do begin
    if (Wert and Bitwert) = Bitwert then SDA(1)
     else SDA(0);   { SDA setzen }
    SCL(1);         { SCL=1 }
    SCL(0);         { SCL=0 }
    Bitwert := Bitwert div 2;
  end;
  SDA(1);           { SDA=1 }
  SCL(1);           { SCL=1, SDA lesen }
  SCL(0);           { SCL=0 }
end;

function Readi2c(Ack: Byte): byte;
var
  n: Byte;
  d: Byte;
begin
  Buf_adr :=0;
  SDA(1);
  for n:= 1 to 8 do begin
     SCL(1);
     SCL(0);
  end;
  SDA(Ack);
  SCL(1);
  SCL(0);
  Write_USB_Device_Buffer( Buf_adr);
  Read_USB_Device_Buffer( Buf_adr);
  d :=0;
  for n := 1 to 8 do begin
   d:=d*2;
   if  (FT_In_Buffer[0+2*n] and 8) > 0 then d := d + 1;     //
  end;
  Readi2c := d;
end;


procedure I2Cio (NRout: Byte; Nrin: Byte);
var n: Byte;
    i: Byte;
begin
  Buf_adr :=0;
  I2C_Init;
  Start;
  Ausgeben (34);
  for n := 1 to Nrout do begin
    Ausgeben (DataOut[n]);
  end;
  Stop;
  Write_USB_Device_Buffer( Buf_adr);
  Read_USB_Device_Buffer( Buf_adr);
  if Nrin > 0 then begin
    Buf_adr :=0;
    Start;
    Ausgeben (35);
    Write_USB_Device_Buffer( Buf_adr);
    Read_USB_Device_Buffer( Buf_adr);
      for n:= 0 to (Nrin-1) do begin
        R[n] := Readi2c(0);
      end;
      R[Nrin] := Readi2c(1);
    Buf_adr :=0;
    Stop;
    Write_USB_Device_Buffer( Buf_adr);
    Read_USB_Device_Buffer( Buf_adr);
  end;
end;

function GET_INT_STATUS(): Boolean;
var status: Byte;
begin
  DataOut[1]:=$14;
  I2Cio (1,1);
  status:= Readi2c(1);   //Nack
  if status and 128 = 128 then  GET_INT_STATUS := true else  GET_INT_STATUS := false;
end;


procedure waitCTS;
var timeout: Integer;
begin
  if not (GET_INT_STATUS()) then begin
     timeout := 0;
     repeat
        timeout :=timeout +1;
     until GET_INT_STATUS() or (timeout > 20);
  end;
end;


function HexToInt (Hexzahl: String): Byte;
var h, l: Byte;
begin
  h:= ord (Hexzahl[1])-48;
  if h>9 then h:=h-7;
  l:= ord (Hexzahl[2])-48;
  if l>9 then l:=l-7;
  Result := 16*h+l;
end;

function ByteToHex (Dat: Integer): String;
var   Hi, Lo: Integer;
      LoHex, HiHex: String;
begin
  Lo := Dat and 15;
  Hi := Dat div 16;
  if Hi > 9 then Hi := Hi + 7;
  HiHex := Chr (48+Hi);
  if Lo > 9 then Lo := Lo + 7;
  LoHex := Chr (48+Lo);
  Result := HiHex + LoHex;
end;

procedure Prop(Adr: Word; Data : Word);
begin
  waitCTS;
  DataOut[1]:=$12;
  DataOut[2]:=$00;
  DataOut[3]:=hi(Adr);
  DataOut[4]:=lo(Adr);
  DataOut[5]:=hi(Data);
  DataOut[6]:=lo(Data);
  I2Cio (6,0);
end;

procedure Init_RDS();
begin
  Prop ($1502, 1);
end;

procedure Xtal();
begin
  Prop ($0202, 125);   //4 MHz / 125 = 32 kHz
  DELAY (10);
  Prop ($0201, 32000);
end;

procedure RX_VOLUME (L: word);
begin
  Prop ($4000, L);
end;


procedure PowerDown();
begin
  waitCTS;
  DataOut[1]:=$11;
  I2Cio (1,0);
end;

procedure Init_AM();
begin
  waitCTS;
  DataOut[1]:=$01;
  DataOut[2]:=$11;  //32 kHz
  DataOut[3]:=$05;
  I2Cio (3,0);
  //Ausgeben (34);
  //Ausgeben ($01);
  //Ausgeben ($01);
  //Ausgeben ($05);
  DELAY (550);
end;

procedure Init_FM();
begin
  waitCTS;
  DataOut[1]:=$01;
  DataOut[2]:=$10;   //32 kHz
  DataOut[3]:=$05;
  I2Cio (3,0);
 // Ausgeben ($01);
 // Ausgeben ($00);
 // Ausgeben ($05);
  DELAY (550);
end;

procedure AM_Tune_Freq(f: Word);
begin
  waitCTS;
  DataOut[1]:=$40;
  DataOut[2]:=$00;
  DataOut[3]:=hi(f);
  DataOut[4]:=lo(f);
  DataOut[5]:=$00;
  DataOut[6]:=$00;
  I2Cio (6,0);

  //Ausgeben ($40);
  //Ausgeben ($00);
  //Ausgeben (hi(f));
  //Ausgeben (lo(f));
  //Ausgeben ($00);
  //Ausgeben ($00);
 end;

procedure FM_Tune_Freq(f: Word);
begin
  waitCTS;
  DataOut[1]:=$20;
  DataOut[2]:=$00;
  DataOut[3]:=hi(f);
  DataOut[4]:=lo(f);
  DataOut[5]:=$00;
  DataOut[6]:=$00;
  I2Cio (6,0);
 // Ausgeben ($20);
 // Ausgeben ($00);
 // Ausgeben (hi(f));
 // Ausgeben (lo(f));
 // Ausgeben ($00);
 // Ausgeben ($00);
end;

procedure AM_Seek_Freq(Arg1: Byte);
begin
  waitCTS;
  DataOut[1]:=$41;
  DataOut[2]:=Arg1;
  I2Cio (2,0);
  //Ausgeben ($41);
  //Ausgeben (Arg1);
end;

procedure FM_Seek_Freq(Arg1: Byte);
begin
  waitCTS;
  DataOut[1]:=$21;
  DataOut[2]:=Arg1;
  I2Cio (2,0);
  //Ausgeben ($21);
  //Ausgeben (Arg1);
end;



procedure AM_Tune_Status(Arg1:Byte);
begin
  waitCTS;
  DataOut[1]:=$42;
  DataOut[2]:=Arg1;
  I2Cio (2,8);
  //Ausgeben ($42);
  //Ausgeben (Arg1);
 // R[0]:= Readi2c(0);   //Ack
 //  R[8]:= Readi2c(1);   //Nack
end;


procedure FM_RDS_STATUS();
var d,n,j: Byte;
begin
  waitCTS;
  DataOut[1]:=$24;
  DataOut[2]:=$00;
  I2Cio (2,13);
end;




procedure AM_RSQ_Status();
begin
  waitCTS;
  DataOut[1]:=$43;
  DataOut[2]:=$00;
  I2Cio (2,5);
  //Ausgeben ($43);
  //Ausgeben ($00);
  //R[0]:= Readi2c(0);
  //R[5]:= Readi2c(1);
end;

procedure FM_Tune_Status(Arg1: Byte);
begin
  waitCTS;
  DataOut[1]:=$22;
  DataOut[2]:=Arg1;
  I2Cio (2,8);
  //Ausgeben ($22);
  //Ausgeben (Arg1);
 // R[0]:= Readi2c(0);   //Ack
 // R[8]:= Readi2c(1);   //Nack
end;

procedure FM_RSQ_Status();
begin
  waitCTS;
  DataOut[1]:=$23;
  DataOut[2]:=$00;
  I2Cio (2,5);
  //Ausgeben ($23);
  //Ausgeben ($00);
  // R[0]:= Readi2c(0);
  //R[5]:= Readi2c(1);
end;


procedure TForm1.Button2Click(Sender: TObject);
begin
 waitCTS;
 PowerDown;
end;

procedure TForm1.Button3Click(Sender: TObject);
var f: Word;
   Code: Integer;
begin
  Timer1.enabled := false;
  AM_Tune_Status(3);
  val (edit1.text,f,Code);
  delay (20);
  AM_Tune_Freq(f);
  delay (100);
  Timer1.enabled := true;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
    Open_USB_Device;
    Set_USB_Device_BitMode(200,0);      // bit bang ende
    Close_USB_Device;

end;


procedure TForm1.Button5Click(Sender: TObject);
 var cap: real;
begin
  waitCTS;
  AM_RSQ_Status;
  //Edit2.text := IntToStr (R[1]) + ' ' +   IntToStr (R[2]) +  ' ' +IntToStr (R[3]) +  ' ' +IntToStr (R[4]) +  ' ' +IntToStr (R[5]) +  ' '+IntToStr (R[6])   +  ' '+IntToStr (R[7]) ;
  Edit3.text := IntToStr (R[4]) + ' dBuV';
  Edit4.text := IntToStr (R[5]) + ' dB SNR';
  waitCTS;
  AM_Tune_Status(3);
  f := 256* R[2] + R[3];
  Edit1.text := IntToStr (f);
  //Edit2.text := IntToStr (R[1]) + ' ' +   IntToStr (R[2]) +  ' ' +IntToStr (R[3]) +  ' ' +IntToStr (R[4]) +  ' ' +IntToStr (R[5]) +  ' '+IntToStr (R[6])   +  ' '+IntToStr (R[7]) ;
  c := 256 * R[6] + R[7];
  cap := c * 0.095 + 7;
  c := round (cap);
  Edit5.text := IntToStr (c)+ ' pF' ;

  end;

procedure TForm1.Button6Click(Sender: TObject);
var f, c: Word;
  cap: real;
begin
  waitCTS;
  AM_Tune_Status(3);
  f := 256* R[2] + R[3];
  Edit1.text := IntToStr (f);
  //Edit2.text := IntToStr (R[1]) + ' ' +   IntToStr (R[2]) +  ' ' +IntToStr (R[3]) +  ' ' +IntToStr (R[4]) +  ' ' +IntToStr (R[5]) +  ' '+IntToStr (R[6])   +  ' '+IntToStr (R[7]) ;
  c := 256 * R[6] + R[7];
  cap := c * 0.095 + 7;
  c := round (cap);
  Edit5.text := IntToStr (c)+ ' pF' ;
end;

procedure TForm1.Button7Click(Sender: TObject);
var f: Word;
   Code: Integer;
begin
  waitCTS;
  val (edit1.text,f,Code);
  Timer1.enabled := true;
  If f < 2300 Then Prop ($03402, 9);   //9 kHz Weite beim Suchen
  If f > 2300 Then Prop ($03402, 5);   //5 kHz Weite beim Suchen
  If f < 500 Then Prop ($03402, 1);    //1 kHz Weite beim Suchen
  AM_Seek_Freq(10);
end;

procedure TForm1.Button8Click(Sender: TObject);
var f: Word;
   Code: Integer;
begin
  waitCTS;
  val (edit1.text,f,Code);
  Timer1.enabled := true;
  If f < 2300 Then Prop ($03402, 9);   //9 kHz Weite beim Suchen
  If f > 2300 Then Prop ($03402, 5);   //5 kHz Weite beim Suchen
  If f < 500 Then Prop ($03402, 1);    //1 kHz Weite beim Suchen
  AM_Seek_Freq(2);
end;

procedure TForm1.Button9Click(Sender: TObject);
var f: Word;
   n: Byte;
   Code: Integer;
begin
  waitCTS;
  Timer2.enabled := false;
  Timer3.enabled := false;
  FM_Tune_Status(3);
  delay (100);
  val (edit2.text,f,Code);
  waitCTS;
  FM_Tune_Freq(f);
  delay (100);
  Timer2.enabled := true;
   for n := 0 to 63 do Codearray[n] := 32;
   for n := 0 to 31 do Codearray2[n] := 32;
   Edit8.Text := '';
   Edit9.Text := '';
   Edit10.Text := '';
   Edit11.Text := '';
   Zeit  := 0;
end;


procedure TForm1.Timer1Timer(Sender: TObject);
begin
 waitCTS;
 if GET_INT_STATUS then begin
  //Delay (20);
  AM_Tune_Status(0);
  f := 256* R[2] + R[3];
  if f = f_alt then Timer1.enabled := false;
  f_alt := f;
  if f= 0 then F := 6075;
  Edit1.text := IntToStr (f);
  Application.ProcessMessages;
  c := 256 * R[6] + R[7];
  cap := c * 0.095 + 7;
  c := round (cap);
  Edit5.text := IntToStr (c)+ ' pF' ;
  Delay (50);
  AM_RSQ_Status;
  //Edit2.text := IntToStr (R[1]) + ' ' +   IntToStr (R[2]) +  ' ' +IntToStr (R[3]) +  ' ' +IntToStr (R[4]) +  ' ' +IntToStr (R[5]) +  ' '+IntToStr (R[6])   +  ' '+IntToStr (R[7]) ;
  Edit3.text := IntToStr (R[4]) + ' dBuV';
  Edit4.text := IntToStr (R[5]) + ' dB SNR';
  Delay (20);
 end;
end;



procedure TForm1.Button10Click(Sender: TObject);
begin
 timer1.enabled := true;
end;

procedure TForm1.Button11Click(Sender: TObject);
begin
 timer1.enabled := false;
end;

procedure TForm1.TabControl1Change(Sender: TObject);
var code: Integer;
begin
   if TabControl1.TabIndex = 0 then begin
     PanelStart.visible := true;
     PanelFM.visible := false;
     PanelAM.visible := false;
     Application.ProcessMessages;
   end;
   if TabControl1.TabIndex = 1 then begin
     PanelStart.visible := false;
     PanelFM.visible := true;
     PanelAM.visible := false;
     Application.ProcessMessages;
     //ChipReset;
     PowerDown;
     Delay (50);
     Init_FM;
     DELAY (200);
     //Xtal;
     RX_VOLUME (scrollbar2.position);
     val (edit2.text,f,Code);
     Init_RDS;
     FM_Tune_Freq(f);
     Timer1.enabled := false;
     Timer2.enabled := true;
   end;
   if TabControl1.TabIndex = 2 then begin
     Timer3.enabled := false;
     PanelStart.visible := false;
     PanelAM.visible := true;
     PanelFM.visible := false;
     Application.ProcessMessages;
     //ChipReset;
     Delay (50);
     PowerDown;
     Delay (50);
     Init_AM;
     DELAY (200);
     //Xtal;
     RX_VOLUME (scrollbar1.position);
     val (edit1.text,f,Code);
     AM_Tune_Freq(f);
     Timer2.enabled := false;
     Timer1.enabled := true;
   end;
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
  waitCTS;
  RX_VOLUME (scrollbar1.position);
end;


procedure TForm1.RDSClick(Sender: TObject);
var n,i,pos, max, BLED, altFreq, AM: Integer;
var h1, h2, m1, m2: String;
begin
  AM := 0;
  //edit12.text := ' ';
  for n := 1 to 5   do begin
  Application.ProcessMessages;
  if GET_INT_STATUS() then begin
     FM_RDS_STATUS;
 //edit12.text :=edit12.text+ ' '+  inttostr (R[3]);
    if R[3] > 0 then begin     //neue Daten?
    BLED := R[12] and 3;
    if (R[6] and 248)=0 then begin      //0A
     if BLED =0 then begin
      pos :=  R[7] and 3;
       Codearray2[pos*2] := R[10];
       Codearray2[pos*2+1] := R[11];
       altFreq := R[9];
     end;
     if altFreq = 250 then AM :=1;
     if AM = 0 then begin
       if (altFreq > 0) and (altFreq <  206) then begin
         altFreq := 8750 + altFreq*10;
       end;
     end;
     if AM=1 then begin
       if (altFreq > 0) and (altFreq <  16) then begin
         altFreq := 144 + altFreq*9;
       end;
       if (altFreq > 15) and (altFreq <  136) then begin
         altFreq := 522 + altFreq*9;
       end;
       AM :=0;
     end;
    end;
    end;
    end;
    if (R[6] and 248)= 32 then begin      //  2A Radiotext
      pos :=  R[7] and 15;
      Codearray[pos*4] := R[8];
      Codearray[pos*4+1] := R[9];
      Codearray[pos*4+2] := R[10];
      Codearray[pos*4+3] := R[11];
    end;
    if (R[6] and 248)= 64 then begin      //  4A, Time
     UTCoffset := (R[11] and 31) div 2;
     if R[11] and 32 = 32 then UTCoffset := UTCoffset* -1;
     Minuten := R[11] div 64 + 4 * (R[10] and 15);
     Stunden := R[10] div 16 + 16* (R[9] and 1);
     Zeit := 1;
    end;
       Edit9.text := '';
       for i:= 0 to 7 do begin
         Edit9.Text := Edit9.Text + chr(Codearray2[i]);
        end;
      Edit8.text := '';
      for i:= 0 to 63 do begin
        Edit8.Text := Edit8.Text + chr(Codearray[i]);
       // Application.ProcessMessages; // ' '+ IntToStr(R[n]);
      end;
      Edit10.text := 'Freq: ' + IntToStr(AltFreq);
      if Zeit = 1 then begin
        h1 := IntToStr(Stunden);
        if Stunden < 10 then h1 := '0'+h1;
        h2 := IntToStr(Stunden + UTCoffset);
        if (Stunden + UTCoffset) < 10 then h2 := '0'+h2;
        m1 := IntToStr(Minuten);
        if Minuten < 10 then m1 := '0'+m1;
        Edit11.text := h2+':'+ m1 + '   '+'UTC: '+h1+':'+m1;
      end;
  end;
end;




procedure TForm1.Button12Click(Sender: TObject);
var code: Integer;
begin
 PowerDown;
  Delay (50);
  Init_FM;
  DELAY (200);
  Xtal;
  RX_VOLUME (scrollbar2.position);
  val (edit2.text,f,Code);
  FM_Tune_Freq(f);
 //Timer1.enabled := true;

end;

procedure TForm1.ScrollBar2Change(Sender: TObject);
begin
  RX_VOLUME (scrollbar2.position);
end;

procedure TForm1.Timer2Timer(Sender: TObject);
begin
 if GET_INT_STATUS then begin
  //Delay (20);
  FM_Tune_Status(0);
  f := 256* R[2] + R[3];
  if f = f_alt then Timer2.enabled := false;
  f_alt := f;
  if f= 0 then F := 8880;
  Edit2.text := IntToStr (f);
  Application.ProcessMessages;
  c := 256 * R[6] + R[7];
  cap := c * 0.095 + 7;
  c := round (cap);
  //Edit5.text := IntToStr (c)+ ' pF' ;
  //Delay (50);
  FM_RSQ_Status;
  //Edit2.text := IntToStr (R[1]) + ' ' +   IntToStr (R[2]) +  ' ' +IntToStr (R[3]) +  ' ' +IntToStr (R[4]) +  ' ' +IntToStr (R[5]) +  ' '+IntToStr (R[6])   +  ' '+IntToStr (R[7]) ;
  Edit6.text := IntToStr (R[4]) + ' dBuV';
  Edit7.text := IntToStr (R[5]) + ' dB SNR';
  //Delay (20);
  if rdsaktiv = 1 then Timer3.enabled := true;
 end;
end;

procedure TForm1.Button13Click(Sender: TObject);
var n: byte;
begin
  Timer3.enabled := false;
  delay (200);
  FM_Seek_Freq(10);
   for n := 0 to 63 do Codearray[n] := 32;
  for n := 0 to 31 do Codearray2[n] := 32;
   Edit8.Text := '';
   Edit9.Text := '';
   Edit10.Text := '';
   Edit11.Text := '';
   Zeit  := 0;
   Timer2.enabled := true;
end;

procedure TForm1.Button14Click(Sender: TObject);
var n: Byte;
begin
  Timer3.enabled := false;
   delay (200);
   FM_Seek_Freq(2);
 //  for n := 0 to 63 do Codearray[n] := 32;
 //  for n := 0 to 31 do Codearray2[n] := 32;
   Edit8.Text := '';
   Edit9.Text := '';
   Edit10.Text := '';
   Edit11.Text := '';
   Zeit  := 0;
   Timer2.enabled := true;
end;

procedure TForm1.Button15Click(Sender: TObject);
var f, c: Word;
  cap: real;
  begin
  if GET_INT_STATUS() then begin
  FM_Tune_Status(3);
  f := 256* R[2] + R[3];
  if f = f_alt then Timer2.enabled := false;
  f_alt := f;
  Edit2.text := IntToStr (f);
  c := 256 * R[6] + R[7];
  cap := c * 0.095 + 7;
  c := round (cap);
  Edit5.text := IntToStr (c)+ ' pF' ;
  end;
  Delay (20);
  FM_RSQ_Status;
  //Edit2.text := IntToStr (R[1]) + ' ' +   IntToStr (R[2]) +  ' ' +IntToStr (R[3]) +  ' ' +IntToStr (R[4]) +  ' ' +IntToStr (R[5]) +  ' '+IntToStr (R[6])   +  ' '+IntToStr (R[7]) ;
  Edit6.text := IntToStr (R[4]) + ' dBuV';
  Edit7.text := IntToStr (R[5]) + ' dB SNR';
  Delay (20);
  if GET_INT_STATUS() then begin
    FM_Tune_Status(0);
  f := 256* R[2] + R[3];
  Edit2.text := IntToStr (f);
  //Edit2.text := IntToStr (R[1]) + ' ' +   IntToStr (R[2]) +  ' ' +IntToStr (R[3]) +  ' ' +IntToStr (R[4]) +  ' ' +IntToStr (R[5]) +  ' '+IntToStr (R[6])   +  ' '+IntToStr (R[7]) ;
  c := 256 * R[6] + R[7];
  cap := c * 0.095 + 7;
  c := round (cap);
  //Edit8.text := IntToStr (c)+ ' pF' ;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var n: byte;
begin
  rdsaktiv := 0;
  Zeit := 0;
  Minuten := 0;
  Stunden := 0;
  FT_port := 21;        //0=TXD,Reset, 2=DTR = SDA,2 = RTS=SCL
  Open_USB_Device;
  Set_USB_Device_BitMode(21,4);      //sync bit bang      4
  FT_Current_Baud:= 9600; //    38400  ;      115200
  Set_USB_Device_BaudRate;
  ChipReset;
  TIMEINIT;
    PanelStart.visible := true;
    PanelFM.visible := false;
    PanelAM.visible := false;
    Application.ProcessMessages;
    for n := 0 to 63 do Codearray[n] := 32;
    for n := 0 to 31 do Codearray2[n] := 32;
end;


procedure TForm1.Timer3Timer(Sender: TObject);
begin
  RDSClick (Nil);
end;



procedure TForm1.RDSstopClick(Sender: TObject);
begin
 Timer3.enabled := false;
 rdsaktiv := 0;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 rdsaktiv := 1;
 timer3.enabled := true;
end;



end.
