VERSION 5.00
Begin VB.Form I2C 
   Appearance      =   0  'Flat
   BackColor       =   &H80000016&
   Caption         =   "SI4735 Test 1"
   ClientHeight    =   3750
   ClientLeft      =   1590
   ClientTop       =   1500
   ClientWidth     =   6180
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   Picture         =   "SI4735Test1.frx":0000
   ScaleHeight     =   250
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   412
   Begin VB.OptionButton Option4 
      Appearance      =   0  'Flat
      BackColor       =   &H80000016&
      Caption         =   "COM4"
      Height          =   255
      Left            =   3960
      TabIndex        =   12
      Top             =   3240
      Width           =   1095
   End
   Begin VB.OptionButton Option3 
      Appearance      =   0  'Flat
      BackColor       =   &H80000016&
      Caption         =   "COM3"
      Height          =   255
      Left            =   2760
      TabIndex        =   11
      Top             =   3240
      Width           =   1095
   End
   Begin VB.CommandButton Command6 
      Caption         =   "Suchen"
      Height          =   495
      Left            =   3480
      TabIndex        =   10
      Top             =   2520
      Width           =   1215
   End
   Begin VB.CommandButton Command5 
      Caption         =   " kHz"
      Height          =   495
      Left            =   1800
      TabIndex        =   9
      Top             =   2520
      Width           =   1095
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Suchen"
      Height          =   495
      Left            =   3480
      TabIndex        =   8
      Top             =   840
      Width           =   1215
   End
   Begin VB.CommandButton Command3 
      Caption         =   "AM"
      Height          =   495
      Left            =   240
      TabIndex        =   7
      Top             =   1800
      Width           =   1935
   End
   Begin VB.CommandButton Command2 
      Caption         =   "/100 MHz"
      Height          =   495
      Left            =   1800
      TabIndex        =   6
      Top             =   840
      Width           =   1095
   End
   Begin VB.CommandButton Command1 
      Caption         =   "FM"
      Height          =   495
      Left            =   240
      TabIndex        =   5
      Top             =   120
      Width           =   1935
   End
   Begin VB.TextBox Text4 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   240
      TabIndex        =   4
      Text            =   "549"
      Top             =   2520
      Width           =   1215
   End
   Begin VB.TextBox Text3 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   240
      TabIndex        =   3
      Text            =   "9920"
      Top             =   840
      Width           =   1215
   End
   Begin VB.HScrollBar HScroll1 
      Height          =   375
      Left            =   2880
      Max             =   63
      TabIndex        =   2
      Top             =   240
      Value           =   63
      Width           =   2295
   End
   Begin VB.OptionButton Option1 
      Appearance      =   0  'Flat
      BackColor       =   &H80000016&
      Caption         =   "COM1"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   360
      TabIndex        =   0
      Top             =   3240
      Width           =   1095
   End
   Begin VB.OptionButton Option2 
      Appearance      =   0  'Flat
      BackColor       =   &H80000016&
      Caption         =   "COM2"
      Height          =   255
      Left            =   1560
      TabIndex        =   1
      Top             =   3240
      Value           =   -1  'True
      Width           =   1095
   End
   Begin VB.Line Line1 
      X1              =   0
      X2              =   400
      Y1              =   104
      Y2              =   104
   End
End
Attribute VB_Name = "I2C"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim Status, Freq, RSSI, SNR, VCAP
Sub i2cStart()
    DTR 1  'SDA 0
    RTS 1  'SCL 0
End Sub

Sub i2cStop()
    DTR 1  'SDA 0
    RTS 0  'SCL 1
    DTR 0  'SDA 1
End Sub

Function i2cOut(Wert) As Integer
    i2cOut = 1       'kein Fehler
    Bit = 128
    For n = 1 To 8
      If (Wert And Bit) = 0 Then DTR 1 Else DTR 0
      RTS 0          'Clock
      RTS 1
      Bit = Bit / 2
    Next n
    DTR 0            'SDA 1
    RTS 0            '9. Clockimpuls fr Ack
    If CTS = 0 Then i2cOut = 0  'Fehler
    RTS 1
End Function

Sub i2cAck()
    DTR 1
    RTS 0     'Ack
    RTS 1
    DTR 0
End Sub

Sub i2cNak()
    DTR 0
    RTS 0     'Nak
    RTS 1
End Sub

Function i2cIn()
    Bit = 128
    Wert = 0
    For n = 1 To 8
        RTS 0   'SCL
        If CTS = 0 Then Wert = Wert + Bit
        RTS 1
        Bit = Bit / 2
    Next n
    i2cIn = Wert
End Function

Private Sub Prop(Adr, Data)
    i2cStart
    i2cOut 34
    i2cOut &H12
    i2cOut &H0
    i2cOut Adr \ 256
    i2cOut Adr And 255
    i2cOut Data \ 256
    i2cOut Data And 255
    i2cStop
End Sub
Private Sub Xtal()
    Prop &H202, 58
    Prop &H201, 31779
    DELAY 100
End Sub

Sub FM_Seek_Freq()
   i2cStart
   i2cOut 34
   i2cOut &H21
   i2cOut &H8
   i2cStop
End Sub
Sub AM_Seek_Freq()
   i2cStart
   i2cOut 34
   i2cOut &H41
   i2cOut &H8
   i2cStop
End Sub
Sub FM_Tune_Freq(f)
  i2cStart
  i2cOut 34
  i2cOut &H20
  i2cOut &H0
  i2cOut f \ 256
  i2cOut f And 255
  i2cOut& H0
  i2cStop
End Sub

Sub AM_Tune_Freq(f)
  i2cStart
  i2cOut 34
  i2cOut &H40
  i2cOut &H0
  i2cOut f \ 256
  i2cOut f And 255
  i2cOut& H0
  i2cStop
End Sub

Sub FM_Tune_Status()
  i2cStart
  i2cOut 34
  i2cOut &H22
  i2cOut &H3
  i2cStop
  i2cStart
  i2cOut 35
  Status = i2cIn(): i2cAck
  R1 = i2cIn(): i2cAck
  R2 = i2cIn(): i2cAck
  R3 = i2cIn(): i2cAck
  Freq = 256 * R2 + R3
  R4 = i2cIn(): i2cAck
  RSSI = R4
  R5 = i2cIn(): i2cAck
  SNR = R5
  R6 = i2cIn(): i2cAck
  R7 = i2cIn(): i2cNak
  VCAP = R7
  i2cStop
End Sub

Sub AM_Tune_Status()
  i2cStart
  i2cOut 34
  i2cOut &H42
  i2cOut &H3
  i2cStop
  i2cStart
  i2cOut 35
  Status = i2cIn(): i2cAck
  R1 = i2cIn(): i2cAck
  R2 = i2cIn(): i2cAck
  R3 = i2cIn(): i2cAck
  Freq = 256 * R2 + R3
  R4 = i2cIn(): i2cAck
  RSSI = R4
  R5 = i2cIn(): i2cAck
  SNR = R5
  R6 = i2cIn(): i2cAck
  R7 = i2cIn(): i2cNak
  VCAP = 256 * R6 + R7
  i2cStop
End Sub
Sub AM_RSQ_Status()
  i2cStart
  i2cOut 34
  i2cOut &H43
  i2cOut &H0
  i2cStop
  i2cStart
  i2cOut 35
  Status = i2cIn(): i2cAck
  R1 = i2cIn(): i2cAck
  R2 = i2cIn(): i2cAck
  R3 = i2cIn(): i2cAck
  Freq = 256 * R2 + R3
  R4 = i2cIn(): i2cAck
  RSSI = R4
  R5 = i2cIn(): i2cNak
  SNR = R5
  i2cStop
End Sub

Private Sub Command1_Click()
 
 TXD 1
 DELAY 100
 i2cStop
 DELAY 10
 TXD 0
 
  i2cStart
  R = i2cOut(34) 'Bus-Adresse PCF8574
  i2cOut (&H1)      '01
  i2cOut (&H10)     '10 UKW, 32 KHz Osz.
  i2cOut (&H5)      '01
  i2cStop
  DELAY 250
 ' Xtal
  DELAY 50
     
  i2cStart
  i2cOut 34
  i2cOut &H20
  i2cOut &H0
  i2cOut &H22
  i2cOut &HB0
  i2cOut& H0
  i2cStop

End Sub

Private Sub Command10_Click()
Timer1.Enabled = False
End Sub

Private Sub Command2_Click()
  f = Val(Text3)
  FM_Tune_Freq (f)
End Sub

Private Sub Command3_Click()
 TXD 1
 DELAY 100
 i2cStop
 DELAY 10
 TXD 0
 i2cStart
 R = i2cOut(34) 'Bus-Adresse
 i2cOut (&H1)      '01
 i2cOut (&H11)     '11 AM, 32 kHz
 i2cOut (&H5)      '01
 i2cStop
 DELAY 250
 'Xtal  'kein Vorteiler wenn 32 kHz
 DELAY 50
 AM_Seek_Freq
End Sub

Private Sub Command4_Click() 'FM-SEEK
  FM_Seek_Freq
  DELAY 500
  FM_Tune_Status
  Text3.Text = Freq
End Sub

Private Sub Command5_Click()
  f = Val(Text4)
  AM_Tune_Freq f
End Sub

Private Sub Command6_Click()
 AM_Seek_Freq
End Sub

Private Sub Form_Load()
 i = OPENCOM("COM2:9600,N,8,1")
 If i = 0 Then
    i = OPENCOM("COM1:9600,N,8,1")
    Option1.Value = True
 End If
 If i = 0 Then MsgBox ("COM Error")
 TIMEINIT
 TXD 0
 DELAY 100
 i2cStop
 DELAY 10
 TXD 1
End Sub

Private Sub Form_Unload(Cancel As Integer)
 TXD 0
 CLOSECOM
End Sub

Private Sub HScroll1_Change()
  l = HScroll1.Value
    i2cStart
    i2cOut 34
    i2cOut &H12
    i2cOut &H0
    i2cOut &H40
    i2cOut &H0
    i2cOut 0
    i2cOut l
    i2cStop
End Sub

Private Sub Option1_Click()
 CLOSECOM
 i = OPENCOM("COM1:9600,N,8,1")
 If i = 0 Then MsgBox ("COM1 Error")
End Sub

Private Sub Option2_Click()
 CLOSECOM
 i = OPENCOM("COM2:9600,N,8,1")
 If i = 0 Then MsgBox ("COM2 Error")
End Sub

Private Sub Option3_Click()
 CLOSECOM
 i = OPENCOM("COM3:9600,N,8,1")
 If i = 0 Then MsgBox ("COM3 Error")
End Sub

Private Sub Option4_Click()
 CLOSECOM
 i = OPENCOM("COM4:9600,N,8,1")
 If i = 0 Then MsgBox ("COM4 Error")
End Sub



