/******************************************************************************************
FileName             : DL410Dlg.cpp
Author               : Fritz Gnther
Purpose              : DL410Dlg.cpp : Implementierungsdatei
Date Of Creation     : 13.10.2005
Modification History :
Date             Modifications
******************************************************************************************/
#include "stdafx.h"
#include "DL410.h"
#include "DL410Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg-Dialogfeld fr Anwendungsbefehl "Info"

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialogfelddaten
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// Vom Klassenassistenten generierte berladungen virtueller Funktionen
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	//}}AFX_VIRTUAL

// Implementierung
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// Keine Nachrichten-Handler
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/*====================================================================================================*\
	Author : Fritz Gnther			Date : 13.10.2005			version 1.0
  ====================================================================================================
	Function :			CDL410Dlg::CDL410Dlg
	Description :	
	Return :			constructor	-	
	Parameters :
			CWnd* pParent	-	
	Note :
\*====================================================================================================*/
CDL410Dlg::CDL410Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDL410Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDL410Dlg)
	m_idKanal = -1;
	m_cszOutput = _T("");
	//}}AFX_DATA_INIT
	// Beachten Sie, dass LoadIcon unter Win32 keinen nachfolgenden DestroyIcon-Aufruf bentigt
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

/*====================================================================================================*\
	Author : Fritz Gnther			Date : 13.10.2005			version 1.0
  ====================================================================================================
	Function :			CDL410Dlg::DoDataExchange
	Description :	
	Return :			void	-	
	Parameters :
			CDataExchange* pDX	-	
	Note :
\*===================================================================================================*/
void CDL410Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDL410Dlg)
	DDX_Radio(pDX, IDC_RB_KANAL1, m_idKanal);
	DDX_Text(pDX, IDC_TP_OUTPUT, m_cszOutput);
	//}}AFX_DATA_MAP
}

/*====================================================================================================*\
	Author : Fritz Gnther			Date : 13.10.2005			version 1.0
  ====================================================================================================
	Function :			BEGIN_MESSAGE_MAP
	Description :	
	Return :			int (by default)	-	
	Parameters :
			CDL410Dlg	-	
			CDialog	-	
	Note :
\*====================================================================================================*/
BEGIN_MESSAGE_MAP(CDL410Dlg, CDialog)
	//{{AFX_MSG_MAP(CDL410Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_PB_CMD_SEND_7, OnPbCmdSend7)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/*====================================================================================================*\
	Author : Fritz Gnther			Date : 13.10.2005			version 1.0
  ====================================================================================================
	Function :			CDL410Dlg::OnInitDialog
	Description :	
	Return :			BOOL	-	
	Parameters :
	Note :
\*====================================================================================================*/
BOOL CDL410Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Hinzufgen des Menbefehls "Info..." zum Systemmen.

	// IDM_ABOUTBOX muss sich im Bereich der Systembefehle befinden.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{	
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Symbol fr dieses Dialogfeld festlegen. Wird automatisch erledigt
	//  wenn das Hauptfenster der Anwendung kein Dialogfeld ist
	SetIcon(m_hIcon, TRUE);			// Groes Symbol verwenden
	SetIcon(m_hIcon, FALSE);		// Kleines Symbol verwenden
	
	// ZU ERLEDIGEN: Hier zustzliche Initialisierung einfgen
	DL410_Open();

	m_idKanal=0;
	UpdateData(false);
	
	return TRUE;  // Geben Sie TRUE zurck, auer ein Steuerelement soll den Fokus erhalten
}

/*====================================================================================================*\
	Author : Fritz Gnther			Date : 13.10.2005			version 1.0
  ====================================================================================================
	Function :			CDL410Dlg::OnSysCommand
	Description :	
	Return :			void	-	
	Parameters :
			UINT nID	-	
			LPARAM lParam	-	
	Note :
\*====================================================================================================*/
void CDL410Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

/*====================================================================================================*\
	Author : Fritz Gnther			Date : 13.10.2005			version 1.0
  ====================================================================================================
	Function :			CDL410Dlg::OnPaint
	Description :	
						Wollen Sie Ihrem Dialogfeld eine Schaltflche "Minimieren" hinzufgen, bentigen Sie 
						den nachstehenden Code, um das Symbol zu zeichnen. Fr MFC-Anwendungen, die das 
						Dokument/Ansicht-Modell verwenden, wird dies automatisch fr Sie erledigt.
	Return :			void	-	
	Parameters :
	Note :
\*====================================================================================================*/
void CDL410Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // Gertekontext fr Zeichnen

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Symbol in Client-Rechteck zentrieren
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Symbol zeichnen
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

/*====================================================================================================*\
	Author : Fritz Gnther			Date : 13.10.2005			version 1.0
  ====================================================================================================
	Function :			CDL410Dlg::OnQueryDragIcon
	Description :	
						Die Systemaufrufe fragen den Cursorform ab, die angezeigt werden soll, whrend der Benutzer
						das zum Symbol verkleinerte Fenster mit der Maus zieht.
	Return :			HCURSOR	-	
	Parameters :
	Note :
\*====================================================================================================*/
HCURSOR CDL410Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

/*====================================================================================================*\
	Author : Fritz Gnther			Date : 13.10.2005			version 1.0
  ====================================================================================================
	Function :			CDL410Dlg::DL410_Open
	Description :	
	Return :			void	-	
	Parameters :
	Note :
\*====================================================================================================*/
void CDL410Dlg::DL410_Close()
{
	if( m_serialDL410.IsOpen() )
		m_serialDL410.Close();
}

/*====================================================================================================*\
	Author : Fritz Gnther			Date : 13.10.2005			version 1.0
  ====================================================================================================
	Function :			CDL410Dlg::DL410_Open
	Description :	
	Return :			void	-	
	Parameters :
	Note :
\*====================================================================================================*/
void CDL410Dlg::DL410_Open()
{
	DL410_Close();

	// RS232 Schnittstelle initialisieren
	LONG    lLastError = ERROR_SUCCESS;
	CString cszCOMPort;

	cszCOMPort = "\\\\.\\COM1";

	lLastError = m_serialDL410.Open(cszCOMPort);

	if (lLastError != ERROR_SUCCESS)
	{
		//::ShowError(m_serialDL410.GetLastError(), _T("Unable to open COM-port"));
		return;
	}

    // Setup the serial port (9600,8N1, which is the default setting)
    lLastError = m_serialDL410.Setup(	CSerial::EBaud9600,
								CSerial::EData8,
								CSerial::EParNone,
								CSerial::EStop2);

	if (lLastError != ERROR_SUCCESS)
	{
		//::ShowError(m_serialDL410.GetLastError(), _T("Unable to set COM-port setting"));
		return;
	}

	// Setup handshaking (default is no handshaking)
	lLastError = m_serialDL410.SetupHandshaking(CSerial::EHandshakeOff);
	if (lLastError != ERROR_SUCCESS)
		return; // ::ShowError(m_serialDL410.GetLastError(), _T("Unable to set COM-port handshaking"));

	// Use 'non-blocking' reads, because we don't know how many bytes
	// will be received. This is normally the most convenient mode
	// (and also the default mode for reading data).
    lLastError = m_serialDL410.SetupReadTimeouts(CSerial::EReadTimeoutNonblocking);
	if (lLastError != ERROR_SUCCESS)
	{
		//::ShowError(m_serialDL410.GetLastError(), _T("Unable to set COM-port read timeout."));
		return;
	}

	// Die Stromversorgung klappt, 
	// wenn Sie die Leitungen DTR und RTS einschalten. 
	CSerial::CDCB dcb;
	GetCommState(m_serialDL410.m_hFile,&dcb);
	dcb.fDtrControl = DTR_CONTROL_ENABLE;
	dcb.fRtsControl = RTS_CONTROL_ENABLE;
	SetCommState(m_serialDL410.m_hFile,&dcb);

	// DL 410 in Grundzustand
	DL410_SendCmd( "\x00", 10 );
}

/*====================================================================================================*\
	Author : Fritz Gnther			Date : 13.10.2005			version 1.0
  ====================================================================================================
	Function :			CDL410Dlg::DL410_SendCmd
	Description :	
	Return :			BOOL	-	
	Parameters :
			CString cszCMD	-	
			int nCount	-	
	Note :
\*====================================================================================================*/
BOOL CDL410Dlg::DL410_SendCmd( CString cszCMD, int nCount )
{
	if( m_serialDL410.IsOpen() )
	{
		for( int i=0; i<nCount; i++ )
		{
			DWORD	dwDataLen = 1;
			DWORD	dwWritten = 0;

			m_serialDL410.Write(cszCMD,dwDataLen,&dwWritten);
		}
	}
	else
		return false;

	return true;
}

/*====================================================================================================*\
	Author : Fritz Gnther			Date : 13.10.2005			version 1.0
  ====================================================================================================
	Function :			CDL410Dlg::DL410_ReadVal
	Description :	
	Return :			BOOL	-	
	Parameters :
			double &dftValReturn	-	
	Note :
\*====================================================================================================*/
BOOL CDL410Dlg::DL410_ReadVal( double &dftValReturn )
{
	UpdateData();

	if( m_serialDL410.IsOpen() )
	{
		DWORD	dwBytesRead=0;
		char	szBuffer[2];
		LONG	lLastError;

		::Sleep(100);	// sleep time in milliseconds

		// Read data from the COM-port
		lLastError = m_serialDL410.Read(szBuffer,sizeof(szBuffer)-1,&dwBytesRead);

		if (lLastError != ERROR_SUCCESS)
		{
			//return ::ShowError(serial.GetLastError(), _T("Unable to read from COM-port."));
			return false;
		}

		BYTE byte = szBuffer[0];

		if( m_idKanal== 3 )
			dftValReturn = (double)byte;
		else
			//--------------------------------------------
			// bertragungsfunktion
			// fr Temperatur + Lrm-Modul
			//--------------------------------------------
			dftValReturn = ((double)byte-50.0) / 2.0;

		return true;
	}
	else
		return false;
}

/*====================================================================================================*\
	Author : Fritz Gnther			Date : 13.10.2005			version 1.0
  ====================================================================================================
	Function :			CDL410Dlg::OnPbCmdSend7
	Description :	
	Return :			void	-	
	Parameters :
	Note :
\*====================================================================================================*/
void CDL410Dlg::OnPbCmdSend7() 
{
	CString cszCMD;
	double dftVal;
	
	UpdateData();

	cszCMD = "\x07";
	DL410_SendCmd(cszCMD);	

	switch( m_idKanal )
	{
		case 0: cszCMD = "\x01"; break;
		case 1: cszCMD = "\x02"; break;
		case 2: cszCMD = "\x03"; break;
		case 3: cszCMD = "\x04"; break;
	}

	DL410_SendCmd( cszCMD );	
	DL410_ReadVal( dftVal );

	m_cszOutput.Format( "%g", dftVal );

	UpdateData(false);
}

/*====================================================================================================*\
	Author : Fritz Gnther			Date : 13.10.2005			version 1.0
  ====================================================================================================
	Function :			CDL410Dlg::OnClose
	Description :	
	Return :			void	-	
	Parameters :
	Note :
\*====================================================================================================*/
void CDL410Dlg::OnClose() 
{
	DL410_Close();
	
	CDialog::OnClose();
}