library CLUSB4;
{CLUSB.DLL  B.Kainka 2003, V.Klein 2006}

uses Windows,
  SysUtils,
  Classes;

type _lIn  = record
    bFunction : Byte;
    bValue1 : Byte;
    bValue2 : Byte;
    bValue3 : Byte;
end;

type _lOut  = record
    bAck : Byte;
    bValue1 : Byte;
    bValue2 : Byte;
    bValue3 : Byte;
    bValue4 : Byte;
    bValue5 : Byte;
    bValue6 : Byte;
    bValue7 : Byte;
end;


var  SaveExit: Pointer;
     ch1, ch2,ch3,ch4: Integer;
     i:Integer;
     DigOut:Array[0..255] of integer ;
     DigIn: Integer;
     error:Integer;

procedure InOut(p_CompulabNr:Integer);
var DeviceHandle: THandle;
    nBytes: DWord;
    bResult: Boolean;
    lIn: _lIn;
    lOut: _lOut;
    l_DeviceStr:String;
begin
  error := -1;
  l_DeviceStr := '\\.\CompuLABusb_'+ IntToStr(p_CompulabNr);
  lIn.bFunction := 6;
  lIn.bValue1 := DigOut[p_CompulabNr];
  DeviceHandle := CreateFile (pchar(l_DeviceStr),Generic_write,File_Share_write,nil,open_existing,0,0);
  bResult := false;
  ch1:= 0; ch2:=0; ch3:= 0; ch4:=0;
  if (DeviceHandle <> INVALID_HANDLE_VALUE) then begin
     bResult := DeviceIoControl(DeviceHandle,$08,@lIn,sizeof(lIn),@lOut,sizeof (lOut),nBytes,nil);
     CloseHandle (DeviceHandle);
  end;
  if bResult then begin
    DigIn := lOut.bValue1;
    ch1 := (4*lOut.bValue2+ (lOut.bValue4 and 15));
    ch2 := (4*lOut.bValue3+ (lOut.bValue4 div 15));
    ch3 := (4*lOut.bValue5+ (lOut.bValue7 and 15));
    ch4 := (4*lOut.bValue6+ (lOut.bValue7 div 15));
    error :=0;
  end;
end;

procedure WrRAM(p_CompulabNr:Integer;Adresse, Wert: Byte);
var lIn: _lIn;
    lOut: _lOut;
    DeviceHandle: THandle;
    bResult: Boolean;
    nBytes: DWord;
    l_DeviceStr:String;
begin
  l_DeviceStr := '\\.\CompuLABusb_'+ IntToStr(p_CompulabNr);
  lIn.bFunction := 23;
  lIn.bValue1 := Adresse;
  lIn.bValue2 := Wert;
  Error := -1;
  DeviceHandle := CreateFile (pchar(l_DeviceStr),Generic_write,File_Share_write,nil,open_existing,0,0);
  if (DeviceHandle <> INVALID_HANDLE_VALUE) then begin
    bResult:=DeviceIoControl(DeviceHandle,$04,@lIn,sizeof(lIn),@lOut,sizeof (lOut),nBytes,nil);
    CloseHandle (DeviceHandle);
    IF bResult then Error := 0;
  end;
end;

procedure DOUT (p_CompulabNr:Integer;Value: Integer); stdcall;
begin
  DigOut[p_CompulabNr] := Value;
  InOut(p_CompulabNr);
end;

function DIN(p_CompulabNr:Integer): Integer; stdcall;
begin
  InOut(p_CompulabNr);
  result := DigIn;
end;

function AIN (p_CompulabNr:Integer;Kanal: Integer): Integer; stdcall;
begin
   case kanal of
     1,2: begin
           InOut(p_CompulabNr);
           if Kanal = 1 then result := ch1 else result := ch2;
          end;
     3,4: begin
           InOut(p_CompulabNr);
           if Kanal = 3 then result := ch3 else result := ch4;
          end;
     5,6: begin
           WrRAM(p_CompulabNr,$34,$00);
           InOut(p_CompulabNr);
           WrRAM(p_CompulabNr,$34,$80);
           if Kanal = 5 then result := ch1 else result := ch2;
          end;
     7,8: begin
           WrRAM(p_CompulabNr,$34,$00);
           InOut(p_CompulabNr);
           WrRAM(p_CompulabNr,$34,$80);
           if Kanal = 7 then result := ch3 else result := ch4;
          end;
     9,10: begin
           WrRAM(p_CompulabNr,$34,$40);
           InOut(p_CompulabNr);
           WrRAM(p_CompulabNr,$34,$80);
           if Kanal = 9 then result := ch1 else result := ch2;
          end;
     11,12: begin
           WrRAM(p_CompulabNr,$34,$40);
           InOut(p_CompulabNr);
           WrRAM(p_CompulabNr,$34,$80);
           if Kanal = 11 then result := ch3 else result := ch4;
           end
      else result := -1;
     end;
end;



Function INIT(p_CompulabNr:Integer):Integer; stdcall;
begin
  Error :=0;
  WrRAM (p_CompulabNr,$34,$80); //AD-Startkanal festlegen;
  result := error;
end;


procedure LibExit;
begin
  ExitProc := SaveExit;
end;

procedure LibraryProc(Reason: Integer);
begin
 if (Reason = DLL_PROCESS_DETACH) then
end;

exports
  DIN index 1,
  DOUT index 2,
  AIN index 3,
  INIT index 4;

begin
  SaveExit := ExitProc;
  ExitProc := @LibExit;
  DLLProc := @LibraryProc;
  Error:=0;
  for i := 0 to 255 do DigOut[i] := 0;
  DigIn := 0;
  ch1 := 0;
  ch2 := 0;
  ch3 := 0;
  ch4 := 0;
  //INIT;
end.


