#------------------------------------------------------------
# Fuss_Ampel_1_CLUSB4.py                  Victor Klein 1.1.07
# Ansteuerung der Fussgaengerampel von AK-Modulbus
# Dauerschleife, Abbruch mit CTRL-C und einem Tastendruck auf dem Interface
# eine Anforderungstaste startet einen Zyklus
# Fussgaengerampel ist eine Klasse, ohne Threads
# kann aus der IDLE gestartet werden
#-----------------------------------------------------------
from CompulabUSB4 import *
from time import *


class Fussgaengerampel(object):
    
    def __init__(self):
        self.test = 1
        self.outwert = 0
        self.wartezeit = 0.5
        self.cl0 = CompulabUSB4()           # Interfaceobjekt 0 schaffen
        self.cl0.INIT(0)                    # und mit 1-tem Compulab verbinden
        self.bitliste = [0,0,0,0,0,0,0,0,0] # b7 b6 b5 b4 b3 b2 b1 b0

    def testausgabe(self):
        if self.test == 1:
            print self.bitliste
            print "bitaus", self.outwert
        
    def berechne(self):
        wert = 0
        for i in self.bitliste:             # 
           wert = 2* wert + i
        return wert
    
    def bitaus(self,nr):
        self.bitliste[8-nr] = 0
        self.outwert = self.berechne()
        self.testausgabe()
        self.cl0.DOUT(self.outwert)
        
    def bitan (self,nr):
        self.bitliste[8-nr] = 1
        self.outwert = self.berechne()
        self.testausgabe()
        self.cl0.DOUT(self.outwert)

    def angefordert(self):
        erg = self.cl0.DIN()
        if erg == 0:
            return 0
        else:
            return 1
        
    def anforderungszyklus(self):
        sleep(self.wartezeit*2)
        self.bitan(1)   #  Fahrampel gelb
        self.bitaus(2)
        sleep(self.wartezeit*2)
        self.bitaus(1)
        self.bitan(0)   #  Fahrampel rot
        sleep(self.wartezeit*2)
        self.bitaus(3)
        self.bitan(4)   #  Anforderungsampel gruen
        sleep(self.wartezeit*6)
        for i in range (5): # Anforderungsampel blinkt gruen
            self.bitaus(4)
            sleep(self.wartezeit/2)
            self.bitan(4)
            sleep(self.wartezeit/2)
        self.bitaus(4)
        self.bitan(3)   # Anforderungsampel rot
        sleep(self.wartezeit*5)
        self.bitan(1)   #  Fahrampel rotgelb
        sleep(self.wartezeit*2)
        self.bitaus(0)
        self.bitaus(1)
        self.bitan(2)   # Fahrampel gruen
        
    def betrieb(self):
        self.bitan(2)   # Fahrampel gruen
        self.bitan(3)   # Anforderungsampel rot
        while 1 :
            while self.angefordert():
                self.anforderungszyklus()
# Ausfuehren-------------------------

f = Fussgaengerampel()
f.betrieb()
    
