#------------------------------------------------------------
# Fuss_u_Kreuzung_3_CLUSB4.py                  Victor Klein 1.1.07
# Ansteuerung der Fussgaengerampel von AK-Modulbus am CompulabUSB 0
# Ansteuerung der Kreuzungsampel von AK_Modukbus am CompulabUSB 1
# Dauerschleife, Abbruch mit CTRL-C und Tastendruck auf dem Interface
# eine Anforderungstaste startet einen Zyklus
# parallele Verarbeitung, verwendet Prozesse, nicht aus der IDLE starten
# mit self.test = 1 kann ein Protokoll eingeschaltet werden
#-----------------------------------------------------------
from CompulabUSB4 import *
from time import *
from threading import *


class Fussgaengerampel(Thread):
    
    def __init__(self):
        Thread.__init__(self)
        self.test = 0
        self.outwert = 0
        self.wartezeit = 0.5
        self.cl0 = CompulabUSB4()           # Interfaceobjekt 0 schaffen
        self.cl0.INIT(0)                    # und mit 0-tem Compulab verbinden
        self.bitliste = [0,0,0,0,0,0,0,0,0] # b7 b6 b5 b4 b3 b2 b1 b0

    def testausgabe(self):
        if self.test == 1:
            print " CompulabUSB 0 ", self.bitliste
            print " CompulabUSB 0 bitaus", self.outwert
        
    def berechne(self):
        wert = 0
        for i in self.bitliste:             # 
           wert = 2* wert + i
        return wert
    
    def bitaus(self,nr):
        self.bitliste[8-nr] = 0
        self.outwert = self.berechne()
        self.testausgabe()
        self.cl0.DOUT(self.outwert)
        
    def bitan (self,nr):
        self.bitliste[8-nr] = 1
        self.outwert = self.berechne()
        self.testausgabe()
        self.cl0.DOUT(self.outwert)

    def angefordert(self):
        erg = self.cl0.DIN()
        if self.test:
            print "CompulabUSB 0 abgefragt ", erg
        if erg == 0:
            return 0
        else:
            return 1
        
    def anforderungszyklus(self):
        sleep(self.wartezeit*2)
        self.bitan(1)   #  Fahrampel gelb
        self.bitaus(2)
        sleep(self.wartezeit*2)
        self.bitaus(1)
        self.bitan(0)   #  Fahrampel rot
        sleep(self.wartezeit*2)
        self.bitaus(3)
        self.bitan(4)   #  Anforderungsampel gruen
        sleep(self.wartezeit*6)
        for i in range (20): # Anforderungsampel blinkt gruen
            self.bitaus(4)
            sleep(self.wartezeit/2)
            self.bitan(4)
            sleep(self.wartezeit/2)
        self.bitaus(4)
        self.bitan(3)   # Anforderungsampel rot
        sleep(self.wartezeit*5)
        self.bitan(1)   #  Fahrampel rotgelb
        sleep(self.wartezeit*2)
        self.bitaus(0)
        self.bitaus(1)
        self.bitan(2)   # Fahrampel gruen
        
    def run(self):
        self.bitan(2)   # Fahrampel gruen
        self.bitan(3)   # Anforderungsampel rot
        while 1 :
            while self.angefordert():
                self.anforderungszyklus()

class Kreuzungsampel(Thread):

    def __init__(self):
        Thread.__init__(self)
        self.test = 0
        self.outwert = 0
        self.wartezeit = 0.3
        self.cl1 = CompulabUSB4()           # Interfaceobjekt 1 schaffen
        self.cl1.INIT(1)                    # und mit 1-tem Compulab verbinden
        self.bitliste = [0,0,0,0,0,0,0,0,0] # b7 b6 b5 b4 b3 b2 b1 b0

    def testausgabe(self):
        if self.test == 1:
            print " CompulabUSB 1 ",self.bitliste
            print " CompulabUSB 1 bitaus", self.outwert
            
    def berechne(self):
        wert = 0
        for i in self.bitliste:             # 
           wert = 2* wert + i
        return wert
    
    def bitaus(self,nr):
        self.bitliste[8-nr] = 0
        self.outwert = self.berechne()
        self.testausgabe()
        self.cl1.DOUT(self.outwert)
        
    def bitan (self,nr):
        self.bitliste[8-nr] = 1
        self.outwert = self.berechne()
        self.testausgabe()
        self.cl1.DOUT(self.outwert)
        
        
    def run(self):
        self.bitan(0)   #  A1 rot
        self.bitan(3)   #  A2 rot
        while 1 :
            self.bitan(0)   # a1 rot
            self.bitan(3)
            sleep(self.wartezeit*5)
            self.bitan(1)   # a1 rotgelb
            sleep(self.wartezeit*2)
            self.bitaus(0)
            self.bitaus(1)
            self.bitan(2)   # a1 gruen
            sleep(self.wartezeit*8)
            self.bitaus(2)
            self.bitan(1)   # a1 gelb
            sleep(self.wartezeit*2)
            self.bitaus(1)
            self.bitan(0)   # a1 rot Wechselpause
            sleep(self.wartezeit*5)
            self.bitan(4)  # a2 rotgelb
            sleep(self.wartezeit*2)
            self.bitaus(3)
            self.bitaus(4)
            self.bitan(5)  # a2 gruen
            sleep(self.wartezeit*8)
            self.bitaus(5)
            self.bitan(4)   # a2 gelb
            sleep(self.wartezeit*2)
            self.bitaus(4)
            self.bitan(3)
            
        
# Ausfuehren-------------------------
f = Fussgaengerampel()
a = Kreuzungsampel()
print "Kreuzungsampel in Betrieb"
print "Fussgaengerampel arbeitet nach Tastendruck"
a.start()
f.start()
    
