; 8052-AH-Basic-Erweiterung, LCD-Anzeige, AD-Wandler
         .org  2000H
         #include 8051.h

         .org  2002H
         .byte 5AH       ;Erweiterung vorhanden

         .org  4030H
         ljmp  LCD        ;Vektor fr UO 1
         .org  403CH
         ljmp  LCD        ;Vektor fr PRINT@
         .org  4100H
         ajmp  LCDInit    ;Vektor fr CALL 0
         ajmp  CURSOR     ;fr CALL 1
         ajmp  AD         ;fr CALL 2

         .org  2048H
         setb  45        ;Erweiterung aktiv
         ret

         .org  2070H
         MOV   DPTR,#VECTOR_TABLE    ;Vektortabelle
         ret

         .org 2078H
         MOV  DPTR,#USER_TABLE       ;Schlsselworte
         ret

             .msfirst        ;Highbyte - Lowbyte
VECTOR_TABLE .word LCDInit
             .word CURSOR
             .word AD

USER_TABLE   .byte 10H       ;Basic-Token
             .text "LCDINIT" ;Schlsselwort
             .byte 00H       ;Ende
             .byte 11H
             .text "CURSOR"
             .byte 00H
             .byte 12H
             .text "AD"
             .byte 0FFH      ;Tabellenende



         .org  4200H
LCD      push  DPH
         push  DPL
         push  ACC

         acall Busy
         mov   A,28       ;Cusorposition
         orl   A,#128
         mov   DPTR,#8000H
         movx  @DPTR,A    ;Cursor setzen
         acall Busy
         mov   A,05       ;Zeichen holen
         cjne  A,#0DH,J1  ;= CR?
         sjmp  CR
J1       cjne  A,#0AH,J2  ;= LF?
         sjmp  End
J2       mov   DPTR,#8001H
         movx  @DPTR,A    ;Zeichen ausgeben
         mov   A,28       ;Bank3, R4, Cursorpos.
         inc   A
         mov   28,A       ;Cursor erhhen
End      pop   ACC
         pop   DPL
         pop   DPH
         ret

Busy     mov   DPTR,#8002H
         movx  A,@DPTR
         jb    ACC.7,Busy
         ret

CR       acall Busy
         mov   a,#32
         mov   DPTR,#8001h
         movx  @DPTR,a
         mov   A,28
         inc   A
         mov   28,a
         anl   A,#63
         cjne  A,#40,CR
J3       mov   a,28
         anl   a,#192
         mov   28,a
         sjmp  End


LCDInit  push  DPH
         push  DPL
         push  ACC

         acall Busy
         mov   DPTR,#8000H
         mov   A,#38H
         movx  @DPTR,A
         acall Busy
         mov   DPTR,#8000H
         mov   A,#06H
         movx  @DPTR,A
         acall Busy
         mov   DPTR,#8000H
         mov   A,#0CH
         movx  @DPTR,A
         acall Busy
         mov   DPTR,#8000H
         mov   A,#01H
         movx  @DPTR,A
         setb  027H       ;PRINT@ freigeben

         pop   ACC
         pop   DPL
         pop   DPH
         ret

CURSOR   push  ACC      ;Akku sichern
         Mov   A,#57
         lcall 030h     ;Ausdruck auswerten
         Mov   A,#1
         lcall 030h     ;als Integer in R3:R1
         mov   A,R1     ;Startparameter holen
         mov   28,A
         pop   ACC      ;Akku wiederherstellen
         ret

         .org  4300H
AD       push  ACC      ;Akku sichern
         Mov   A,#57
         lcall 030h     ;Ausdruck auswerten
         Mov   A,#1
         lcall 030h     ;als Integer in R3:R1
         mov   A,R1     ;Startparameter holen

         clr   0B5h     ;Steuerbyte zum Wandler
         mov   18h,#08  ;Zhler: R1, Bank3
S1       jb    ACC.7,S2
         clr   0B4h     ;Di=0
         sjmp  S3
S2       setb  0B4h     ;Di=1
S3       setb  0B5h     ;Clk=1
         clr   0B5h     ;Clk=0
         rl    A        ;nchstes Bit
         djnz  18h,S1

         mov   18h,#10  ;Warteschleife
S4       djnz  18h,S4

         mov   A,#0     ;Highbyte auslesen
         mov   18h,#4   ;4 mal
S5       setb  0B5h     ;Clk-Impuls
         clr   0B5h
         rl    A
         jnb   0B2h,S6  ;Do lesen
         inc   A
S6       djnz  18h,S5
         mov   R2,A     ;Highbyte in R2

         mov   A,#0     ;Lowbyte lesen
         mov   18h,#8   ;8 mal
S7       setb  0B5h     ;Clk-Impuls
         clr   0B5h
         rl    A
         jnb   0B2h,S8  ;Do lesen
         inc   A
S8       djnz  18h,S7
         mov   R0,A     ;Lowbyte in R0

         mov   A,#154
         lcall 030h     ;auf den Ergebnisstack
         pop   ACC      ;Akku wiederherstellen
         ret

        .end
