;Serielle Schnittstelle des 8051       (PIbus.ASM)
;11,059MHz, 9600 Baud
;Paralleler Interface Bus
#include 8051.H
         .org 0000H

ANFANG   mov   SP,#60H         ;Stackpointer setzten
INIT     clr   TR1             ;Timer 1 stoppen
         mov   TH1,#0FAH       ;6 bis berlauf: 9600 Baud
         mov   TL1,#0FAH
         anl   TMOD,#0FH       ;Timer1: 8-Bit-Auto-Reload
         orl   TMOD,#20H
         setb  TR1             ;Timer Starten
         mov   SCON,#50H       ;InitRS232
         setb  TI
         orl   PCON,#80H       ;SMOD=1

NEXT     acall EMPF            ;Adresse empfangen
         mov   r3,A            ;Adresse speichern
         jb    ACC.7,Lesen     ;Lesebit?
         mov   P2,A            ;Adresse statisch
         acall EMPF            ;Daten empfangen
         mov   P0,A            ;Datenbus ausgeben
         mov   A,r3            ;Adresse 
         acall CS              ;/CS an Port 1 
         clr   P3.6            ;/WR = 0
         nop
         setb  P3.6            ;/WR = 1
         mov   P3,#255         ;alle /CS = 1
         sjmp  NEXT

Lesen    mov   DPL,A           ;A0...A6    
         mov   DPH,A           ;+ A8...A14
         mov   P2,A            ;Adresse statisch
         mov   P0,#255         ;Datenbs hochohmig
         mov   A,r3            ;Adresse 
         acall CS              ;/CS an Port 1 
         clr   P3.7            ;/RD = 0
         nop
         mov   A,P0            ;Daten lesen
         setb  P3.7            ;/RD = 1
         mov   P3,#255         ;alle /CS = 1
         acall SEND            ;Ergebnis senden
         sjmp  NEXT

CS       anl   A,#127          ;Bereich 0...127
         mov   P1,#255         ;Alle /CS-Leitungen 1
         anl   A,#0F0h         ;Bereiche 16 Adressen 
         jnz   Y1              ;0...15
         clr   P3.2            ;Y0 = 0
Y1       subb  A,#16           ;nchste Grupe
         jnz   Y2              ;16...31
         clr   P3.3            ;Y1 = 0
Y2       subb  A,#16           ;nchste Grupe
         jnz   Y3              ;32...47
         clr   P3.4            ;Y2 = 0
Y3       subb  A,#16           ;nchste Grupe
         jnz   Y4              ;48...63 
         clr   P3.5            ;Y3 = 0
Y4       ret


EMPF     jnb   RI,EMPF
         mov   A,SBUF
         clr   RI
         ret

SEND     jnb   TI,SEND
         clr   TI
         mov   SBUF,A
         ret
        .end
