UNIT COM2_96;      {COM2_96.PAS}
 
Interface
uses DOS, CRT;
const BA : Integer = $02F8;  { $03F8=COM1, $02F8=COM2}

procedure Sende (Zeichen :Byte);
function Empfang :Byte;
procedure Init;
procedure DTR (An : Boolean);
procedure RTS (An : Boolean);

Implementation

procedure Sende (Zeichen :Byte);
begin
  while (Port[BA+5] AND 32) = 0 do;  { Sende-Halteregister leer? }
  Port[BA]:=Zeichen;
end;

function Empfang :Byte;
var  i :Word;
begin
  i:=0;
  while ((Port[BA+5] AND 1)=0) AND (i<10000) DO Inc(i);
  if i < 10000                       { Timeout erreicht? }
  then Empfang := Port[BA]
  else Empfang := 0;
end;

procedure Init;
var  i, Dummy :Byte;
begin
  Port[BA+3]:=128;
  Port[BA+0]:=12; { 12: 9600 Baud, 6 :19200 Baud }
  Port[BA+1]:=0;
  Port[BA+3]:=7;  { 8-Bit, n-Parity, 2 Stopbits }
  Port[BA+1]:=0;  { keine Interrupts }
  Port[BA+4]:=0;  { DTR = 0, RTS = 0}
  for i:= 1 to 3 do
    Dummy:=Port[BA];   { UART leeren }
end;

procedure DTR (An : Boolean);
begin
  If An then Port[BA+4] := (Port[BA+4] OR 1) else
     Port[BA+4] := (Port[BA+4] AND 254);
end;

procedure RTS (An : Boolean);
begin
  If An then Port[BA+4] := (Port[BA+4] OR 2) else
     Port[BA+4] := (Port[BA+4] AND 253);
end;

begin
  Init
end.
