;80C535-Entwicklungssystem   (SYSTEM35.ASM)
;12MHz, 9600 Baud

         .org 0000H
         #include 80535.SFR

         ajmp ANFANG           ;Programmanfang nach Reset

         .org 0003H            ;Externer Interrupt 0, INT0
         ljmp 8003H
         .org 000BH            ;berlauf Counter/Timer 0
         ljmp 800BH
         .org 0013H            ;Externer Interrupt 1, INT1
         ljmp 8013H
         .org 001BH            ;berlauf Counter/Timer 1
         ljmp 801BH
         .org 0023H            ;Serieller Interrupt
         ljmp 8023H

         .org  0030H           ;Reserviert fr BASIC-Vectoren
         ljmp  2030H           ;Vektor fr UO 1
         .org  003CH
         ljmp  203CH           ;Vektor fr PRINT@

         .org 0043H            ;AD-Wandler Interrupt
         ljmp 8043H
         .org 004BH            ;Externer Interrupt 2
         ljmp 804BH
         .org 0053H            ;Externer Interrupt 3
         ljmp 8053H
         .org 005BH            ;Externer Interrupt 4
         ljmp 805BH
         .org 0063H            ;Externer Interrupt 5
         ljmp 8063H
         .org 006BH            ;Externer Interrupt 6
         ljmp 806BH


         .org 0080H            ;Hauptprogramm


ANFANG   mov   SP,#60H         ;Stackpointer setzten
         lcall INIT


Haupt    mov   DPTR,#0000H     ;Adresse 0
NEXT     acall EMPF
         jz    NEXT
         mov   R1,A            ;R1 enthlt Kommando
         anl   A,#0F0H         ;Gruppen a 16 Byte ..
HEX00    cjne  A,#00H,HEX10
         ajmp  CMD00
HEX10    cjne  A,#10H,HEX20    ;digitale Ausgaben
         ajmp  CMD10
HEX20    cjne  A,#20H,HEX30    ;digitale Eingaben
         ajmp  CMD20
HEX30    cjne  A,#30H,HEX40    ;analoge Eingaben
         ajmp  CMD30
HEX40    cjne  A,#40H,HEX50    ;analoge Ausgaben
         ajmp  CMD40
HEX50    cjne  A,#50H,HEX60    ;Timer-Kommandos (reserviert)
         ajmp  CMD50
HEX60    cjne  A,#60H,HEX70    ;Speicherzgriffe
         ajmp  CMD60
HEX70    cjne  A,#70H,HEX80    ;Serienmessungen (reserviert)
         ajmp  CMD70
HEX80    cjne  A,#80H,HEX90    ;freie Befehlsgruppen
         ajmp  CMD80
HEX90    cjne  A,#90H,NEXT
HEXEND   ajmp  NEXT

         .org 0100H

EMPF     jnb   RI,EMPF
         mov   A,SBUF
         clr   RI
         ret

SEND     jnb   TI,SEND
         clr   TI
         mov   SBUF,A
         ret

MESSEN   anl   A,#07H          ;Kanal 0...7
         orl   A,#80H          ;BD = 1
         mov   ADCON,A
         mov   DAPR,#00H       ;5V
ADBUSY   jb    BSY,ADBUSY
         mov   A,ADDAT
         ret

AD10     anl   A,#7           ;Kanal
         acall MESSEN
         anl   A,#0C0H        ;Bits 9,10
         mov   R2,A
         rl    A
         rl    A
         mov   B,A            ;Highbyte in B
         rl    A
         rl    A
         ADD   A,R2           ;DA-Byte berechnen
         ADD   A,#40H
         mov   DAPR,A         ;Messung Starten
         acall ADBUSY         ;Lowbyte in A
         ret

DELAY    mov   r2,a           ;R2 reserviert
WARTEN   jnb   TF0,WARTEN     ;0,1ms ber Timer 0
         clr   TF0
         djnz  r2,WARTEN
         ret

INIT     clr   TR0            ;Timer 0 stoppen
         mov   TH0,#09CH      ;100 bis berlauf: 10,0kHz bei 12MHz
         mov   TL0,#09CH
         anl   TMOD,#0F0H     ;Timer0: 8-Bit-Auto-Reload
         orl   TMOD,#02H
         setb  TR0            ;Timer Starten

         setb  BD             ;ADCON.7, Baudratengenerator
         orl   PCON,#80H      ;SMOD=1
         mov   SCON,#50H      ;InitRS232
         setb  TI             ;SCON.1, sendebereit
         ret

RESETRAM mov   R3,#08h        ;High Adr
         mov   R4,#00h        ;Low Adr
         ret

WrRAM    mov   DPH,R3         ;R3:R4, aktuelle Adresse
         mov   DPL,R4
         movx  @DPTR,A        ;schreiben
         inc   DPTR
         mov   R3,DPH
         mov   R4,DPL
         cjne  R3,#80h,WrNEXT
         ljmp  ENDE           ;Bereichsberwachung
WrNEXT   ret

RdRAM    mov   DPH,R3         ;R3:R4, aktuelle Adresse
         mov   DPL,R4
         movx  A,@DPTR        ;lesen
         inc   DPTR
         mov   R3,DPH
         mov   R4,DPL
         cjne  R3,#80h,RdNEXT
         ljmp  ENDE
RdNEXT   ret

ENDE     ajmp  ENDE

         .org 0200H
         ;Einzelkommandos
CMD00    ajmp  NEXT          ;Gruppe 00 ist frei

CMD10    mov   A,R1          ;Gruppe 10h: Portausgaben
         cjne  A,#10H,CMD11
         acall EMPF
         mov   P1,A          ;Ausgabe Port 1
         ajmp  NEXT
CMD11    cjne  A,#11H,CMD12
         acall EMPF
         mov   P3,A          ;Ausgabe Port 3
         ajmp  NEXT
CMD12    cjne  A,#12H,CMD13
         acall EMPF
         mov   P4,A          ;Ausgabe Port 4
         ajmp  NEXT
CMD13    cjne  A,#13H,CMD14
         acall EMPF
         mov   P5,A          ;Ausgabe Port 5
         ajmp  NEXT
CMD14    ajmp  NEXT


CMD20    mov   A,R1          ;Gruppe 20h: Porteingaben
         cjne  A,#20H,CMD21
         mov   A,P1          ;Eingabe Port 1
         acall SEND
         ajmp  NEXT
CMD21    cjne  A,#21H,CMD22
         mov   A,P3          ;Eingabe Port 3
         acall SEND
         ajmp  NEXT
CMD22    cjne  A,#22H,CMD23
         mov   A,P4          ;Eingabe Port 4
         acall SEND
         ajmp  NEXT
CMD23    cjne  A,#23H,CMD24
         mov   A,P5          ;Eingabe Port 5
         acall SEND
         ajmp  NEXT
CMD24    cjne  A,#24H,CMD25
         mov   A,P6          ;Eingabe Port 6
         acall SEND
         ajmp  NEXT
CMD25    ajmp  NEXT

CMD30    mov   A,R1           ;Analag-Eingaben
         anl   A,#08H         ;Bit gesetzt: Auflsung 10 Bit
         jz    AD8            ;30h...37h: 8 Bit
         mov   A,R1
         acall AD10           ;10-Bit Messung
         mov   R2,A           ;Lowbyte sichern
         mov   A,B
         acall SEND           ;Highbyte senden
         acall EMPF           ;Lowbyte mu abgeholt werden
         mov   A,R2
         acall SEND           ;Lowbyte senden
         ajmp  NEXT

AD8      mov   A,R1           ;8-Bit-Messung 0...5V
         anl   A,#7           ;Kanal
         acall MESSEN
         acall SEND
         ajmp  NEXT


CMD40    mov   A,R1           ;Analoge Ausgaben
         anl   A,#03H         ;Analag-Kanle 0...3
         rl    A
         rl    A
         orl   A,#11110011b
         mov   P3,A           ;Adresse an P3 ausgeben
         acall EMPF           ;Ausgabebyte
         mov   P4,A           ;Daten ausgeben an P4
         clr   0B4H           ;P3.4, /WR-Signal
         setb  0B4H           ;P3.4
         ajmp  NEXT

CMD50    ajmp  NEXT           ;reserviert fr Timer


CMD60    mov   A,R1           ;Speicherzugriffe
         cjne  A,#60H,CMD61   ;60h: Download
DOWNLOAD acall EMPF
         mov   DPH,A          ;Highbyte Adresse
         acall EMPF
         mov   DPL,A          ;Lowbyte Adresse
DOWNLOOP mov   A,#1
         acall SEND           ;"1" senden
         acall EMPF           ;"1" empfangen
         jz    DOWNENDE       ;"0" = Ende
         acall EMPF           ;Byte empfangen
         movX  @DPTR,A        ;ins RAM schreiben
         INC   DPTR
         ajmp  DOWNLOOP
DOWNENDE ajmp  NEXT
CMD61    cjne  A,#61H,CMD62   ;61h: Programmstart
         acall EMPF
         mov   DPH,A          ;Highbyte Adresse
         acall EMPF
         mov   DPL,A          ;Lowbyte Adresse
         mov   A,#0
         jmp   @A+DPTR        ;Sprung zur Startadresse
CMD62    cjne  A,#62H,CMD63   ;62h: Adresse-Schreiben
         acall EMPF
         mov   DPH,A          ;1.Byte: Adresse-High
         acall EMPF
         mov   DPL,A          ;2.Byte: Adresse-Low
         acall EMPF
         movX  @DPTR,A        ;3.Byte: Daten
         ajmp  NEXT
CMD63    cjne  A,#63H,CMD64   ;62h: Adresse-Lesen
         acall EMPF
         mov   DPH,A          ;1.Byte: Adresse-High
         acall EMPF
         mov   DPL,A          ;2.Byte: Adresse-Low
         movX  A,@DPTR        ;Byte zurck: Daten
         acall SEND
         ajmp  NEXT
CMD64    cjne  A,#64H,CMD65   ;64h: Register-Schreiben
         acall EMPF
         mov   R0,A           ;1. Byte: Registeradresse
         acall EMPF
         mov   @R0,A          ;2. Byte: Daten
         ajmp  NEXT
CMD65    cjne  A,#65H,CMD66   ;65h: Register-Lesen
         acall EMPF
         mov   R0,A           ;1. Byte: Registeradresse
         mov   A,@R0
         acall SEND           ;Byte zurck: Daten
         ajmp  NEXT
CMD66    cjne  A,#66H,CMD67   ;66H: SFR-Schreiben
         mov   DPTR,#0008H    ;Adresse 0008
         mov   A,#0F5H        ;F5 = "mov SFR,A"
         movx  @DPTR,A        ;Befehlsbyte ins RAM
         acall EMPF           ;SFR empfangen
         inc   DPTR
         movx  @DPTR,A        ;Adresse 0009
         inc   DPTR
         mov   A,#22H         ;22 = "ret"
         movx  @DPTR,A        ;Adresse 000A
         acall EMPF           ;Datum empfangen
         lcall 8008H          ;Programm ausfhren
CMD67    cjne  A,#67H,CMD68   ;67H: SFR-Schreiben
         mov   DPTR,#0008H    ;Adresse 0008
         mov   A,#0E5H        ;E5 = "mov A,SFR"
         movx  @DPTR,A        ;Befehlsbyte ins RAM
         acall EMPF           ;SFR empfangen
         inc   DPTR
         movx  @DPTR,A        ;Adresse 0009
         inc   DPTR
         mov   A,#22H         ;22 = "ret"
         movx  @DPTR,A        ;Adresse 000A
         lcall 8008H          ;Programm ausfhren
         acall SEND
CMD68    cjne  A,#68H,CMD69  ;68h: RAM-Auslesen
READRAM  acall EMPF
         mov   DPH,A         ;Highbyte Adresse
         acall EMPF
         mov   DPL,A         ;Lowbyte Adresse
READLOOP mov   A,#1
         acall EMPF          ;"1" empfangen
         jz    READENDE      ;"0" = Ende
         movx  A,@DPTR       ;RAM lesen
         acall SEND
         INC   DPTR
         ajmp  READLOOP
READENDE ajmp  NEXT
CMD69    ajmp  NEXT

CMD70 ajmp  NEXT             ;reserviert

CMD80 ajmp  NEXT             ;reserviert

         .org 3C00h          ;Umschaltung Mode 3
         ljmp  0000
.end
