
; 8052-AH-Basic-Erweiterung fr 80535
; 12 MHz, 9600 Baud

         #include 80535.SFR
         .org 2000H

         .org  2001H
         .byte 0AAH      ;externe Reset-Rountine

         .org  2002H
         .byte 5AH       ;Befehlerweiterung vorhanden


         ;8052-AH-Basic-Erweiterung: LCD-Treiber
         .org  2030H      ;umgelenkt von 4030h
         ljmp  LCD        ;Vektor fr UO 1
         .org  203CH      ;umgelenkt von 403Ch
         ljmp  LCD        ;Vektor fr PRINT@

         .org  2048H
         setb  45
         ret

         .org  2070H
         mov   DPTR,#VECTOR_TABLE
         ret

         .org 2078H
         mov  DPTR,#USER_TABLE
         ret


         .org  2090H
         mov   r0,#0FFH     ;Ende des internen RAM
         clr   a

RESET1   mov   @r0,a        ;Int. RAM leeren
         djnz  R0,RESET1
         mov   SP,#4DH      ;Stack auf 4D setzen
         mov   3EH,#4DH     ;SP-Holding-Reg

         mov   R3,#3FH      ;gesetzt: 16 K
         mov   R1,0FFH      ;0000...3FFF
         mov   DPTR,#0FFFFH
RESET2   inc   DPTR         ;Anfang mit 0000
         clr   a
         movx  @DPTR,a
         mov   a,r3
         cjne  a,DPH,RESET2
         mov   a,R1
         cjne  a,DPL,RESET2 ;Speicher gelscht

         mov   DPTR,#10AH   ;MTOP vermerken
         mov   a,R3
         movx  @DPTR,a
         inc   DPTR
         mov   a,#0FFH
         movx  @DPTR,a

         mov   DPTR,#104H   ;VARTOP vermerken
         mov   a,R3
         movx  @DPTR,a
         inc   DPTR
         mov   a,#0FFH
         movx  @DPTR,a

         mov   DPTR,#108H   ;DIMUSE vermerken (528=210H)
         mov   a,#02H
         movx  @DPTR,a
         inc   DPTR
         mov   a,#10H
         movx  @DPTR,a

         mov   DPTR,#106H   ;VARUSE vermerken
         mov   a,R3
         movx  @DPTR,a
         inc   DPTR
         mov   a,#0FFH
         movx  @DPTR,a

         mov   09H,#0FEH    ;Agument Stack
         mov   11H,#0FEH    ;Control Stack

         mov   DPTR,#512    ;Basic Start-Adresse
         mov   a,#01H       ;"end of file"
         movx  @DPTR,a

         sjmp  RESET3

XTAL     .byte  88H
         .byte  00H
         .byte  00H
         .byte  00H
         .byte  00H
         .byte  12H

RESET3   mov   DPTR,#XTAL   ;Quarz eingeben (12,000MHz)
         mov   a,09
         clr   c
         subb  a,#06H
         mov   09,a
         mov   r0,a
         mov   P2,#01
         mov   r1,#06

RESET4   clr   a
         movc  a,@a+DPTR
         movx  @r0,a
         inc   DPTR
         dec   r0
         djnz  r1,RESET4

         mov   a,#58
         lcall 30H

         mov   13H,#02H     ;Basic-start 512 = 200H
         mov   14H,#00H

    ; RS232 mit Baudratengenerator: 9,6 Kilobaud bei  12 MHz
INIT     setb  BD              ;ADCON.7, Baudratengenerator
         orl   PCON,#80H       ;SMOD=1
         mov   SCON,#50H       ;InitRS232
         setb  TI              ;SCON.1, sendebereit

         mov A,#7           ;CR ausgeben
         lcall 30H
         mov   R3,#22H      ;Startadrese
         mov   R1,#00H      ;Einschaltmeldung
         setb  52
         mov   A,#6         ;Text ausgeben
         lcall 30H

         CLR    A
         LJMP  30H          ;Zum Kommandomodus

         .org 2200H

         .TEXT "MCS-51 BASIC V1.1 / 80535"
         .BYTE '"'

                   .msfirst

VECTOR_TABLE       .WORD RUN_P4
                   .WORD RUN_INP4
                   .WORD RUN_P5
                   .WORD RUN_INP5
                   .WORD RUN_INP6
                   .WORD RUN_CTRL
                   .WORD RUN_DAPR
                   .WORD RUN_ADCON
                   .WORD RUN_LCDINIT
                   .WORD RUN_CURSOR

USER_TABLE         .BYTE 10H       ;Token
                   .TEXT "P4"      ;Statement
                   .BYTE 00H       ;Trennung
                   .BYTE 11H
                   .TEXT "INP4"
                   .BYTE 00H
                   .BYTE 12H
                   .TEXT "P5"
                   .BYTE 00H
                   .BYTE 13H
                   .TEXT "INP5"
                   .BYTE 00H
                   .BYTE 14H
                   .TEXT "INP6"
                   .BYTE 00H
                   .BYTE 15H
                   .TEXT "CTRL"
                   .BYTE 00H
                   .BYTE 16H
                   .TEXT "DAPR"
                   .BYTE 00H
                   .BYTE 17H
                   .TEXT "ADCON"
                   .BYTE 00H
                   .BYTE 18H
                   .TEXT "LCDINIT"
                   .BYTE 00H
                   .BYTE 19H
                   .TEXT "CURSOR"
                   .BYTE 00H
                   .BYTE 0CEH      ;ehemals R2CAP
                   .TEXT "IO"
                   .BYTE 0FFH      ;Tabellenende

RUN_P4              mov   A,#64    ;Hole Zeichen "="
                    lcall 30H
                    cjne  A,#0EAh,SKIP  ;Token fr "=" ?
                    mov   A,#57
                    lcall 30H      ;Ausdruck auswerten
                    mov   A,#01
                    lcall 30H      ;Umwandeln in Integer in R3:R1
                    mov   P4,R1    ;Ausgabe an P4
SKIP                ret

RUN_P5              mov   A,#64
                    lcall 30H
                    cjne  A,#0EAh,SKIP
                    mov   A,#57
                    lcall 30H
                    mov   A,#01
                    lcall 30H
                    mov   P5,R1    ;Ausgabe an P5
                    ret

RUN_CTRL            mov   A,#64
                    lcall 30H
                    cjne  A,#0EAh,SKIP
                    mov   A,#57
                    lcall 30H
                    mov   A,#01
                    lcall 30H
                    mov   18h,R1   ;Wert nach R0/Bank3
                    ret

RUN_DAPR            mov   A,#64
                    lcall 30H
                    cjne  A,#0EAh,SKIP
                    mov   A,#57
                    lcall 30H
                    mov   A,#01
                    lcall 30H
                    mov   19h,R1   ;Wert nach R1/Bank3
                    ret

RUN_ADCON           mov   A,#64
                    lcall 30H
                    cjne  A,#0EAh,SKIP
                    mov   A,#57
                    lcall 30H
                    mov   A,#01
                    lcall 30H
                    mov   1Ah,R1   ;Wert nach R2/Bank3
                    ret

RUN_INP4            mov   R0,P4    ;lowbyte = P4
                    mov   R2,#0    ;highbyte = 0
                    mov   A,#154   ;Umwandlung in Fliekomma
                    lcall 30H      ;und auf den Argumnt Stack
                    ret

RUN_INP5            mov   R0,P5    ;R5 lesen
                    mov   R2,#0
                    mov   A,#154
                    lcall 30H
                    ret

RUN_INP6            mov   R0,P6    ;R6 lesen
                    mov   R2,#0
                    mov   A,#154
                    lcall 30H
                    ret

 ;******** Auswertung der umbenannten IO-Funktion ****************

                    .org 2300H       ;umgelenkte Ausgabe
                          ;lcall 2300H, umgelenkt von 088B

                    mov   1BH,A      ;Akku sichern in R3/bank3
                    mov   A,18H      ;R0/Bank3, CTRL lesen
                    cjne  A,#01,O2   ;Ctrl = 1?
                    mov   P1,R1      ;Ausgabe P1
                    mov   A,1BH      ;Akku wiederherstellen
                    ret
O2                  cjne  A,#04,O3   ;Ctrl = 4?
                    mov   P4,R1      ;Ausgabe P4
                    mov   A,1BH
                    ret
O3                  cjne  A,#05,O4   ;Ctrl = 4?
                    mov   P5,R1      ;Ausgabe P5
                    mov   A,1BH
                    ret
O4                  cjne  A,#10,O5   ;Ctrl = 10?
                    mov   0A8h,R1    ;Ausgabe IEN0
                    mov   A,1BH
                    ret
O5                  cjne  A,#11,O6   ;Ctrl = 11?
                    mov   0A9h,R1    ;Ausgabe IP0
                    mov   A,1BH
                    ret
O6                  cjne  A,#12,O7   ;Ctrl = 12?
                    mov   0B8h,R1    ;Ausgane IEN1
                    mov   A,1BH
                    ret
O7                  cjne  A,#13,O8   ;Ctrl = 13?
                    mov   0B9h,R1    ;Ausgabe IP1
                    mov   A,1BH
                    ret
O8                  cjne  A,#14,O9   ;Ctrl = 14?
                    mov   0C0h,R1    ;Ausgabe IRCON
                    mov   A,1BH
                    ret
O9                  cjne  A,#20,O10  ;Ctrl = 20?
                    mov   0C1h,R1    ;Ausgabe CCEN
                    mov   A,1BH
                    ret
O10                 cjne  A,#21,O11  ;Ctrl = 21?
                    mov   0C3h,R3    ;Ausgabe CCH1
                    mov   0C2h,R1    ;Ausgabe CCL1
                    mov   A,1BH
                    ret
O11                 cjne  A,#22,O12  ;Ctrl = 22?
                    mov   0C5h,R3    ;Ausgabe CCH2
                    mov   0C4h,R1    ;Ausgabe CCL2
                    mov   A,1BH
                    ret
O12                 cjne  A,#23,O13  ;Ctrl = 23?
                    mov   0C7h,R3    ;Ausgabe CCH3
                    mov   0C6H,R1    ;Ausgabe CCL3
                    mov   A,1BH
                    ret
O13                 cjne  A,#24,O14  ;Ctrl = 24?
                    mov   0CBh,R3    ;Ausgabe CRCH
                    mov   0CAh,R1    ;Ausgabe CRCL
                    mov   A,1BH
                    ret
O14                 mov   A,1BH
                    ret

                    .org 2400H        ;umgelenkte Eingabe
                          ;lcall 2400H, umgelenkt von 14CA

                    mov   1BH,A       ;Akku sichern in R3/Bank3
                    mov   A,18H       ;R0/Bank3, CTRL lesen
                    cjne  A,#01,I2    ;CTRL = 1?
                    mov   R0,P1       ;Eingabe P1
                    mov   R2,#0
                    mov   A,1BH       ;Akku wiederherstellen
                    ret
I2                  cjne  A,#04,I3    ;Ctrl = 4?
                    mov   R0,P4       ;Eingabe P4
                    mov   R2,#0
                    mov   A,1BH
                    ret
I3                  cjne  A,#05,I4    ;Ctrl = 5?
                    mov   R0,P5       ;Eingabe P5
                    mov   R2,#0
                    mov   A,1BH
                    ret
I4                  cjne  A,#06,I5    ;Ctrl = 6?
                    mov   R0,P6       ;Eingabe P6
                    mov   R2,#0
                    mov   A,1BH
                    ret
I5                  cjne  A,#30,I6    ;Ctrl = 30? AD-Wandler:
                    mov   A,1AH       ;"ADCON" lesen, R2/Bank3
                    anl   A,#07H      ;0...7 maskieren
                    orl   A,#80H      ;BD = 1 (nur 9600Bd/12MHz)
                    mov   ADCON,A     ;AD Kanal setzen
                    mov   DAPR,19H    ;AD-Mebereich setzen
ADBUSY2             jb    BSY,ADBUSY2
                    mov   R0,ADDAT    ;Ergebnis lesen
                    mov   R2,#0
                    mov   A,1BH
                    ret
I6                  cjne  A,#10,I7    ;CTRL = 10?
                    mov   R0,0A8h     ;Eingabe IEN0
                    mov   R2,#0
                    mov   A,1BH
                    ret
I7                  cjne  A,#11,I8    ;Ctrl = 11?
                    mov   R0,0A9h     ;Eingabe IP0
                    mov   R2,#0
                    mov   A,1BH
                    ret
I8                  cjne  A,#12,I9    ;Ctrl = 12?
                    mov   R0,0BA      ;Eingabe IEN1
                    mov   R2,#0
                    mov   A,1BH
                    ret
I9                  cjne  A,#13,I10   ;Ctrl = 13?
                    mov   R0,0A9h     ;Eingabe IP1
                    mov   R2,#0
                    mov   A,1BH
                    ret
I10                 cjne  A,#14,I11   ;Ctrl = 14?
                    mov   R0,0C0h     ;Eingabe IRCON
                    mov   R2,#0
                    mov   A,1BH
                    ret
I11                 cjne  A,#20,I12   ;Ctrl = 20?
                    mov   R0,0C1      ;Eingabe CCEN
                    mov   R2,#0
                    mov   A,1BH
                    ret
I12                 cjne  A,#21,I13   ;Ctrl = 21?
                    mov   R0,0C2h     ;Eingabe CCL1
                    mov   R2,0C3H     ;Eingabe CCH1
                    mov   A,1BH
                    ret
I13                 cjne  A,#22,I14   ;Ctrl = 22?
                    mov   R0,0C4h     ;Eingabe CCL2
                    mov   R2,0C5h     ;Eingabe CCH2
                    mov   A,1BH
                    ret
I14                 cjne  A,#23,I15   ;Ctrl = 23?
                    mov   R0,0C6h     ;Eingabe CCL3
                    mov   R2,0C7h     ;Eingabe CCH3
                    mov   A,1BH
                    ret
I15                 cjne  A,#24,I16   ;Ctrl = 24?
                    mov   R0,0CAh     ;Eingabe CRCL
                    mov   R2,0CBh     ;Eingabe CRCH
                    mov   A,1BH
                    ret
I16                 mov   A,1BH
                    ret

LCD          push  DPH
             push  DPL
             push  ACC

             acall Busy
             mov   A,28       ;Cusorposition
             orl   A,#128
             mov   DPTR,#8000H
             movx  @DPTR,A    ;Cursor setzen
             acall Busy
             mov   A,05       ;Zeichen holen
             cjne  A,#0DH,J1  ;= CR?
             sjmp  CR
J1           cjne  A,#0AH,J2  ;= LF?
             sjmp  End
J2           mov   DPTR,#8001H
             movx  @DPTR,A    ;Zeichen ausgeben
             mov   A,28       ;Bank3, R4, Cursorpos.
             inc   A
             mov   28,A       ;Cursor erhhen
End          pop   ACC
             pop   DPL
             pop   DPH
             ret

Busy         mov   DPTR,#8002H
             movx  A,@DPTR
             jb    ACC.7,Busy
             ret

CR           acall Busy
             mov   a,#32
             mov   DPTR,#8001h
             movx  @DPTR,a
             mov   A,28
             inc   A
             mov   28,a
             anl   A,#63
             cjne  A,#40,CR
J3           mov   a,28
             anl   a,#192
             mov   28,a
             sjmp  End

RUN_LCDINIT  push  DPH
             push  DPL
             push  ACC
             acall Busy
             mov   DPTR,#8000H
             mov   A,#38H
             movx  @DPTR,A
             acall Busy
             mov   DPTR,#8000H
             mov   A,#06H
             movx  @DPTR,A
             acall Busy
             mov   DPTR,#8000H
             mov   A,#0CH
             movx  @DPTR,A
             acall Busy
             mov   DPTR,#8000H
             mov   A,#01H
             movx  @DPTR,A
             setb  027H       ;PRINT@ freigeben

             pop   ACC
             pop   DPL
             pop   DPH
             ret

RUN_CURSOR   push  ACC      ;Akku sichern
             Mov   A,#57
             lcall 030h     ;Ausdruck auswerten
             Mov   A,#1
             lcall 030h     ;als Integer in R3:R1
             mov   A,R1     ;Startparameter holen
             mov   28,A
             pop   ACC      ;Akku wiederherstellen
             ret
        .end
