unit Serai6;
{6 Eingangskanle und 2 mal GND an acht Klemmen:
  1: GND
  2: -5...+5      Ch0
  3: 0...10       Ch1
  4: -10...+10    Ch2
  5: -10...+10    Ch3
  6: 0...10       Ch4
  7: -5...+5      Ch5
  8: GND
  }


interface

uses
  RSlineINC,//Enthlt die Deklarationen der RSline32.DLL
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function Messung (Kanal: Integer): Word;
  //Achtung, Messen und Auslesen mit gleichem Takt, Kanal versetzt
var BitOut, BitIn, DataOut, DataIn: Word;
begin
  DataOut := Kanal * 16;  // Adresse auf Bits 4...7
  DataIn := 0;
  for BitOut := 1 to 10 do begin
    RTS ((DataOut And 128)div 128);   //Din
    DataIn := DataIn * 2;
    DTR (1);                          //Clock
    DataIn := DataIn + CTS;           //Dout
    DTR (0);
    DataOut := DataOut * 2;
  end;
  Messung := DataIn;
  While DSR() =0 do;         //EOC abwarten
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  OpenCom(2);
  DTR(0);
  RTS (0);
  TXD (1);
  Timer1.Enabled := true;
end;


procedure TForm1.Timer1Timer(Sender: TObject);
begin
  Messung (0);  //Kanal 0, -5...+5V fr Edit1
  Edit1.Text := floattostr((Messung (1)-512)/512 * 5) ;
  Edit2.Text := floattostr((Messung (2))/1024 * 10) ;
  Edit3.Text := floattostr((Messung (3)-512)/512 * 10) ;
  Edit4.Text := floattostr((Messung (4)-512)/512 * 10) ;
  Edit5.Text := floattostr((Messung (5))/1024 * 10) ;
  Edit6.Text := floattostr((Messung (0)-512)/512 * 5) ;
  //Achtung! Kanal ist immer der folgende, ausgelesen wird der letzte.
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  TXD (0);   //wichtig fr TLC1543: +5V abschalten, wegen CS
end;

end.
